/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.interceptors;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ManifestExposureInterceptor
extends HandlerInterceptorAdapter
implements ServletContextAware {
    public static final String MANIFEST = "manifest";
    private String manifest;
    private ServletContext context;

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (this.manifest == null) {
            InputStream input = this.context.getResourceAsStream("/META-INF/MANIFEST.MF");
            this.manifest = ManifestExposureInterceptor.convertStreamToString(input);
        }
        request.setAttribute(MANIFEST, (Object)this.manifest);
    }

    public void setServletContext(ServletContext servletContext) {
        this.context = servletContext;
    }

    private static String convertStreamToString(InputStream is) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            sb.append(line + "\n\f");
        }
        is.close();
        return sb.toString();
    }
}

