/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.support;

import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.shept.org.springframework.web.servlet.mvc.support.DateTimeLocaleConstants;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class ConfigurableLocaleDependentFormatResolver
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Locale defaultLocale = Locale.getDefault();
    private Map<Locale, Map<DateTimeLocaleConstants, String>> dateTimeLocales;

    protected Map<DateTimeLocaleConstants, String> getDateTimeLocaleConstants(Locale loc) {
        Map<DateTimeLocaleConstants, String> localeConstants = this.dateTimeLocales.get(loc);
        if (localeConstants == null) {
            if (localeConstants == null && loc.getCountry() != null) {
                localeConstants = this.dateTimeLocales.get(new Locale(loc.getCountry()));
            }
            if (localeConstants == null && loc.getLanguage() != null) {
                localeConstants = this.dateTimeLocales.get(new Locale(loc.getLanguage()));
            }
            if (localeConstants == null) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)("Locale constants definition not found for locale " + loc + ". Using default locale instead"));
                }
                localeConstants = this.dateTimeLocales.get(this.defaultLocale);
            }
        }
        return localeConstants;
    }

    public String resolveProperty(Locale loc, DateTimeLocaleConstants property) {
        String value = this.getDateTimeLocaleConstants(loc).get((Object)property);
        if (value == null) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)("Property " + (Object)((Object)property) + " not found using locale " + loc + ". Check your configuration for dateTimeLocales. Trying default locale instead"));
            }
            if ((value = this.getDateTimeLocaleConstants(this.defaultLocale).get((Object)property)) == null) {
                throw new IllegalStateException("Property " + (Object)((Object)property) + " undefined in locale " + loc);
            }
        }
        return value;
    }

    public void setDateTimeLocales(Map<Locale, Map<DateTimeLocaleConstants, String>> locales) {
        this.dateTimeLocales = locales;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notEmpty(this.dateTimeLocales, (String)"The dateTimeLocales definitions have not yet been initialized");
        Assert.state((boolean)this.dateTimeLocales.containsKey(this.defaultLocale), (String)("The default locale '" + this.defaultLocale + "' is not properly configured"));
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }
}

