/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.support;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.shept.org.springframework.beans.support.CommandSupplier;
import org.shept.org.springframework.beans.support.ModelSupplier;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.ChainConfiguration;
import org.shept.persistence.ModelCreation;
import org.shept.persistence.provider.DaoUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.dao.support.DaoSupport;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ModelUtils {
    public static String initMethod = "initialize";
    protected static Log logger = LogFactory.getLog(ModelUtils.class);

    public static Object unwrapIfNecessary(Object commandOrModel) {
        if (commandOrModel == null) {
            return null;
        }
        if (commandOrModel.getClass().isArray() && ((Object[])commandOrModel).length > 0) {
            return ModelUtils.unwrapIfNecessary(((Object[])commandOrModel)[0]);
        }
        if (commandOrModel instanceof ModelSupplier) {
            return ModelUtils.unwrapIfNecessary(((ModelSupplier)commandOrModel).getModel());
        }
        return commandOrModel;
    }

    public static Object wrapIfNecessary(Object model) {
        if (model instanceof CommandSupplier) {
            return ModelUtils.wrapIfNecessary(((CommandSupplier)model).getCommand());
        }
        return model;
    }

    public static Object copyModel(Object model) {
        Object newModel = null;
        if (model == null) {
            return null;
        }
        newModel = ModelUtils.cloneCopy(model);
        if (newModel != null) {
            return newModel;
        }
        return ModelUtils.shallowCopy(model);
    }

    public static Object copyModel(DaoSupport dao, Object model) {
        Object newModel = null;
        if (model == null) {
            return null;
        }
        newModel = ModelUtils.cloneCopy(model);
        if (newModel != null) {
            return newModel;
        }
        newModel = DaoUtils.isEntity(dao, model) ? DaoUtils.deepCopyModel(dao, model) : ModelUtils.shallowCopy(model);
        return newModel;
    }

    private static Object cloneCopy(Object model) {
        Object newModel;
        block3: {
            newModel = null;
            Method mth = ReflectionUtils.findMethod(model.getClass(), (String)"clone");
            if (mth != null) {
                try {
                    newModel = ReflectionUtils.invokeMethod((Method)mth, (Object)model);
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug((Object)("Cloning " + model + " failure"), (Throwable)ex);
                }
            }
        }
        return newModel;
    }

    private static Object shallowCopy(Object model) {
        Object newModel = BeanUtils.instantiate(model.getClass());
        BeanUtils.copyProperties((Object)model, (Object)newModel);
        return newModel;
    }

    public static ModelCreation getNewModelTemplate(Class<?> clazz, Object model, String initString) {
        if (clazz == null) {
            return null;
        }
        Object entity = BeanUtils.instantiate(clazz);
        if (!(entity instanceof ModelCreation)) {
            logger.warn((Object)("The entity model '" + entity.getClass() + "' does not implement the interface 'ModelCreation' itself and /or " + " the return value of all of its '#initialize()' - methods. " + " No new row objects will be created."));
            return null;
        }
        if (StringUtils.hasText((String)initString)) {
            ModelUtils.initialize(entity, initString);
        }
        if (model != null) {
            ModelUtils.initialize(entity, model);
        }
        return (ModelCreation)entity;
    }

    public static ModelCreation getNewModelTemplate(Class<?> clazz, String initString) {
        return ModelUtils.getNewModelTemplate(clazz, null, initString);
    }

    public static ModelCreation getNewModelTemplate(ChainConfiguration cc, Object model, String initString) {
        return ModelUtils.getNewModelTemplate(cc.getEntityClass(), model, initString);
    }

    public static void initialize(Object target, Object sourceModel) {
        if (sourceModel == null) {
            return;
        }
        Assert.notNull((Object)target, (String)("The object being initialized with '" + sourceModel + "' (of class '" + sourceModel.getClass() + "') may not be null"));
        Method mth = ReflectionUtils.findMethod(target.getClass(), (String)initMethod, (Class[])new Class[]{sourceModel.getClass()});
        if (mth == null) {
            String message = "The object of class '" + target.getClass() + "' cannot be initialized from model '" + sourceModel.getClass() + "' Method '" + initMethod + "(" + sourceModel.getClass() + ")' is missing";
            if (sourceModel instanceof String) {
                logger.info((Object)message);
            } else {
                logger.warn((Object)message);
            }
        } else {
            ReflectionUtils.invokeMethod((Method)mth, (Object)target, (Object[])new Object[]{sourceModel});
        }
    }
}

