/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.support;

import org.shept.util.StringUtilsExtended;
import org.springframework.util.StringUtils;

public class RequestValueUtils {
    public static final String PARAMETER_VALUE_SEPARATOR = "::";
    public static final String SAVE_PREFIX = "save";
    public static final String DELETE_PREFIX = "delete";

    public static int getIndexParameter(String param) {
        if (!StringUtils.hasText((String)param)) {
            return -1;
        }
        try {
            return Integer.valueOf(param);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public static ChainParameter getChainParameter(String param) {
        String[] parms = StringUtils.delimitedListToStringArray((String)param, (String)PARAMETER_VALUE_SEPARATOR);
        ChainParameter cp = parms.length == 1 ? new ChainParameter(parms[0]) : (parms.length == 2 ? new ChainParameter(parms[0], parms[1]) : new ChainParameter(parms[0], parms[1], RequestValueUtils.getIndexParameter(parms[2])));
        return cp;
    }

    public static KeyValueParameter getKeyValueParameter(String param) {
        String[] parms = StringUtils.delimitedListToStringArray((String)param, (String)PARAMETER_VALUE_SEPARATOR);
        KeyValueParameter kvp = new KeyValueParameter();
        if (parms.length > 0) {
            kvp.key = parms[0];
        }
        if (parms.length > 1) {
            kvp.value = parms[1];
        }
        return kvp;
    }

    public static class KeyValueParameter {
        private String key;
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class ChainParameter {
        private String name;
        private int index = -1;
        private String param;

        public ChainParameter(String name) {
            this.name = name;
        }

        public ChainParameter(String name, String param) {
            this.name = name;
            if (RequestValueUtils.getIndexParameter(param) != -1) {
                this.index = RequestValueUtils.getIndexParameter(param);
            } else {
                this.param = param;
            }
        }

        public ChainParameter(String name, String param, int index) {
            this.name = name;
            this.index = index;
            this.param = param;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isIndexed() {
            return this.index > -1;
        }

        public String getSelectorParam() {
            return this.param;
        }

        public String getSelector() {
            return StringUtilsExtended.getReadAccessor(this.param);
        }

        public String getName() {
            return this.name;
        }

        public String getSubFormName() {
            return this.name;
        }
    }
}

