/*
 * Decompiled with CFR 0.152.
 */
package org.shept.persistence.provider;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.hibernate.EntityMode;
import org.hibernate.SessionFactory;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;
import org.shept.persistence.provider.UnsupportedDataProviderException;
import org.springframework.beans.BeanUtils;
import org.springframework.dao.support.DaoSupport;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class DaoUtils {
    private static ClassMetadata getClassMetadata(DaoSupport dao, Object model) {
        DaoUtils.checkProvider(dao);
        SessionFactory hsf = ((HibernateDaoSupport)dao).getHibernateTemplate().getSessionFactory();
        if (model == null) {
            return null;
        }
        return hsf.getClassMetadata(model.getClass());
    }

    public static boolean isEntity(DaoSupport dao, Object entityModelTemplate) {
        if (dao == null) {
            return false;
        }
        ClassMetadata modelMeta = DaoUtils.getClassMetadata(dao, entityModelTemplate);
        return modelMeta != null;
    }

    public static Object getIdValue(DaoSupport dao, Object entityModelTemplate) {
        ClassMetadata modelMeta = DaoUtils.getClassMetadata(dao, entityModelTemplate);
        if (null == modelMeta) {
            return null;
        }
        return modelMeta.getIdentifier(entityModelTemplate, EntityMode.POJO);
    }

    public static boolean isNewModel(DaoSupport dao, Object model) {
        ClassMetadata modelMeta = DaoUtils.getClassMetadata(dao, model);
        if (null == modelMeta) {
            return false;
        }
        Serializable idValue = modelMeta.getIdentifier(model, EntityMode.POJO);
        if (idValue == null) {
            return true;
        }
        Type type = modelMeta.getIdentifierType();
        if (!(type instanceof ComponentType)) {
            return false;
        }
        PropertyDescriptor[] desc = BeanUtils.getPropertyDescriptors(idValue.getClass());
        for (int i = 0; i < desc.length; ++i) {
            Method mth = desc[i].getReadMethod();
            Object val = ReflectionUtils.invokeMethod((Method)mth, (Object)idValue);
            if (null != val) continue;
            return true;
        }
        return false;
    }

    public static Object deepCopyModel(DaoSupport dao, Object entityModelTemplate) {
        ClassMetadata modelMeta = DaoUtils.getClassMetadata(dao, entityModelTemplate);
        if (null == modelMeta) {
            return null;
        }
        Object modelCopy = DaoUtils.shallowCopyModel(dao, entityModelTemplate, false);
        boolean isCopyId = DaoUtils.isNewModel(dao, entityModelTemplate);
        Serializable idValue = modelMeta.getIdentifier(entityModelTemplate, EntityMode.POJO);
        if (null != idValue && isCopyId) {
            String idName = modelMeta.getIdentifierPropertyName();
            Object idCopy = BeanUtils.instantiateClass(idValue.getClass());
            BeanUtils.copyProperties((Object)idValue, (Object)idCopy, (String[])new String[]{idName});
            modelMeta.setIdentifier(modelCopy, (Serializable)idCopy, EntityMode.POJO);
        }
        String[] names = modelMeta.getPropertyNames();
        Type[] types = modelMeta.getPropertyTypes();
        for (int i = 0; i < modelMeta.getPropertyNames().length; ++i) {
            if (!types[i].isComponentType()) continue;
            String propName = names[i];
            Object propValue = modelMeta.getPropertyValue(entityModelTemplate, propName, EntityMode.POJO);
            Object propCopy = DaoUtils.shallowCopyModel(dao, propValue, true);
            modelMeta.setPropertyValue(modelCopy, propName, propCopy, EntityMode.POJO);
        }
        return modelCopy;
    }

    public static Object shallowCopyModel(DaoSupport dao, Object entityModelTemplate, boolean includeId) {
        ClassMetadata modelMeta = DaoUtils.getClassMetadata(dao, entityModelTemplate);
        if (null == modelMeta) {
            return null;
        }
        Object modelCopy = BeanUtils.instantiateClass(entityModelTemplate.getClass());
        if (!includeId) {
            String idName = modelMeta.getIdentifierPropertyName();
            BeanUtils.copyProperties((Object)entityModelTemplate, (Object)modelCopy, (String[])new String[]{idName});
        } else {
            BeanUtils.copyProperties((Object)entityModelTemplate, (Object)modelCopy);
        }
        return modelCopy;
    }

    public static void checkProvider(DaoSupport dao) {
        if (!(dao instanceof HibernateDaoSupport)) {
            throw new UnsupportedDataProviderException("This version only supports Hibernate as the dao wrapper.");
        }
    }

    private static Serializable getIdValue_old(DaoSupport dao, Object model) {
        DaoUtils.checkProvider(dao);
        String idStr = DaoUtils.getIdentifierPropertyName_old(dao, model);
        if (!StringUtils.hasText((String)idStr)) {
            return null;
        }
        Method idMth = ReflectionUtils.findMethod(model.getClass(), (String)("get" + StringUtils.capitalize((String)idStr)));
        Serializable idxObj = (Serializable)ReflectionUtils.invokeMethod((Method)idMth, (Object)model);
        return idxObj;
    }

    private static String getIdentifierPropertyName_old(DaoSupport dao, Object model) {
        DaoUtils.checkProvider(dao);
        ClassMetadata meta = DaoUtils.getClassMetadata((DaoSupport)((HibernateDaoSupport)dao), model);
        if (meta == null) {
            return null;
        }
        return meta.getIdentifierPropertyName();
    }

    private static Object copyTemplate_Experimental(HibernateDaoSupport dao, Object entityModelTemplate) {
        ClassMetadata modelMeta = DaoUtils.getClassMetadata((DaoSupport)dao, entityModelTemplate);
        if (null == modelMeta) {
            return null;
        }
        String idName = modelMeta.getIdentifierPropertyName();
        Object modelCopy = BeanUtils.instantiateClass(entityModelTemplate.getClass());
        BeanUtils.copyProperties((Object)entityModelTemplate, (Object)modelCopy, (String[])new String[]{idName});
        Type idType = modelMeta.getIdentifierType();
        if (null == idType || !idType.isComponentType()) {
            return modelCopy;
        }
        Object idValue = modelMeta.getPropertyValue(entityModelTemplate, idName, EntityMode.POJO);
        if (null == idValue) {
            return modelCopy;
        }
        Object idCopy = BeanUtils.instantiate(idValue.getClass());
        BeanUtils.copyProperties((Object)idValue, (Object)idCopy);
        if (null == idValue || null != idType) {
            return modelCopy;
        }
        Method idMth = ReflectionUtils.findMethod(entityModelTemplate.getClass(), (String)("set" + StringUtils.capitalize((String)idName)), (Class[])new Class[0]);
        if (idMth != null) {
            ReflectionUtils.invokeMethod((Method)idMth, (Object)modelCopy, (Object[])new Object[]{idCopy});
        }
        return modelCopy;
    }
}

