/*
 * Decompiled with CFR 0.152.
 */
package org.shept.persistence.provider;

import org.shept.beans.support.ExampleDefinition;
import org.shept.beans.support.FilterDefinition;
import org.shept.beans.support.QueryDefinition;
import org.shept.beans.support.ReloadableAssociation;
import org.shept.org.springframework.orm.hibernate3.support.HibernateDaoSupportExtended;
import org.shept.persistence.provider.ScrollingListProvider;
import org.shept.persistence.provider.UnsupportedDataProviderException;
import org.shept.persistence.provider.hibernate.HibernateAssociationProvider;
import org.shept.persistence.provider.hibernate.HibernateCriteriaDefinition;
import org.shept.persistence.provider.hibernate.HibernateCriteriaListProviderImpl;
import org.shept.persistence.provider.hibernate.HibernateExampleListProviderImpl;
import org.shept.persistence.provider.hibernate.HibernateQueryListProviderImpl;
import org.shept.persistence.provider.hibernate.UnsupportedFilterException;
import org.springframework.beans.BeanUtils;
import org.springframework.dao.support.DaoSupport;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class ScrollingListProviderFactory {
    private DaoSupport dao;
    private Integer initialLoadSize = 10;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ScrollingListProvider getScrollingList(FilterDefinition filterProvider) throws UnsupportedFilterException {
        void var2_6;
        if (HibernateDaoSupportExtended.class.isAssignableFrom(this.getDao().getClass())) {
            if (filterProvider instanceof QueryDefinition) {
                Class<HibernateQueryListProviderImpl> clazz = HibernateQueryListProviderImpl.class;
            } else if (filterProvider instanceof HibernateCriteriaDefinition) {
                Class<HibernateCriteriaListProviderImpl> clazz = HibernateCriteriaListProviderImpl.class;
            } else if (filterProvider instanceof ExampleDefinition) {
                Class<HibernateExampleListProviderImpl> clazz = HibernateExampleListProviderImpl.class;
            } else {
                if (!(filterProvider instanceof ReloadableAssociation)) throw new UnsupportedFilterException("The filterProvider class: " + filterProvider.getClass() + " is not supported for Hibernate access");
                Class<HibernateAssociationProvider> clazz = HibernateAssociationProvider.class;
            }
        } else {
            if (!HibernateDaoSupport.class.isAssignableFrom(this.getDao().getClass())) throw new UnsupportedDataProviderException("This version only supports Hibernate as the dao wrapper.");
            throw new UnsupportedDataProviderException("For DataAccess via Hibernate the extended version of HibernateSupport is neccessary. Please use HibernateDaoSupportExtended instead of HibernateDaoSupport. If your dao object inherits from HibernateDaoSupport please inherit from HibernateDaoSupportExtended instead");
        }
        ScrollingListProvider sp = (ScrollingListProvider)BeanUtils.instantiateClass((Class)var2_6);
        sp.setDao(this.dao);
        sp.setLoadSize(this.initialLoadSize);
        return sp;
    }

    public DaoSupport getDao() {
        return this.dao;
    }

    public void setDao(DaoSupport dao) {
        this.dao = dao;
    }

    public Integer getInitialLoadSize() {
        return this.initialLoadSize;
    }

    public void setInitialLoadSize(Integer initialLoadSize) {
        this.initialLoadSize = initialLoadSize;
    }
}

