/*
 * Decompiled with CFR 0.152.
 */
package org.shept.persistence.provider.hibernate;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.shept.org.springframework.web.servlet.mvc.support.ModelUtils;
import org.shept.persistence.ModelCreation;
import org.shept.persistence.provider.hibernate.HibernateCriteriaDefinition;
import org.springframework.beans.support.SortDefinition;
import org.springframework.util.StringUtils;

public abstract class HibernateCriteriaFilter
implements HibernateCriteriaDefinition,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Class<?> entityClass;
    private SortDefinition defaultSortDefinition;

    @Override
    public DetachedCriteria getCriteria(SortDefinition sortDefinition) {
        SortDefinition sd = this.defaultSortDefinition;
        DetachedCriteria crit = DetachedCriteria.forClass(this.getEntityClass());
        if (null != sortDefinition && StringUtils.hasText((String)sortDefinition.getProperty())) {
            sd = sortDefinition;
        }
        if (null != sd && StringUtils.hasText((String)sd.getProperty())) {
            String prop = sd.getProperty();
            String[] pathArr = StringUtils.split((String)prop, (String)".");
            if (pathArr == null) {
                pathArr = new String[]{prop};
            }
            if (pathArr.length > 2) {
                throw new UnsupportedOperationException("Sort Criteria Definition '" + prop + "' may only nest one level deep");
            }
            if (pathArr.length == 2) {
                crit.createAlias(pathArr[0], pathArr[0]);
            }
            if (sortDefinition.isAscending()) {
                crit.addOrder(Order.asc((String)prop));
            } else {
                crit.addOrder(Order.desc((String)prop));
            }
        }
        return crit;
    }

    @Override
    public ModelCreation getNewModelTemplate() {
        return ModelUtils.getNewModelTemplate(this.entityClass, "???");
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public SortDefinition getDefaultSortDefinition() {
        return this.defaultSortDefinition;
    }

    public void setDefaultSortDefinition(SortDefinition defaultSortDefinition) {
        this.defaultSortDefinition = defaultSortDefinition;
    }
}

