/*
 * Decompiled with CFR 0.152.
 */
package org.shept.services.jcaptcha;

import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.image.ImageCaptchaService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.shept.services.jcaptcha.CaptchaServiceSingleton;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ImageCaptchaServlet
extends HttpServlet
implements ApplicationContextAware {
    private ApplicationContext ctx;
    private static final long serialVersionUID = 1L;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.ctx = ctx;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        BufferedImage challenge = null;
        try {
            String captchaId = httpServletRequest.getSession().getId();
            ImageCaptchaService captchaService2 = CaptchaServiceSingleton.getInstance();
            Map services = this.ctx.getBeansOfType(ImageCaptchaService.class);
            if (services.size() == 1) {
                for (ImageCaptchaService captchaService2 : services.values()) {
                }
            }
            challenge = captchaService2.getImageChallengeForID(captchaId, httpServletRequest.getLocale());
        }
        catch (IllegalArgumentException e) {
            httpServletResponse.sendError(404);
            return;
        }
        catch (CaptchaServiceException e) {
            httpServletResponse.sendError(500);
            return;
        }
        httpServletResponse.setHeader("Cache-Control", "no-store");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setDateHeader("Expires", 0L);
        httpServletResponse.setContentType("image/jpeg");
        ServletOutputStream responseOutputStream = httpServletResponse.getOutputStream();
        ImageIO.write((RenderedImage)challenge, "jpeg", (OutputStream)responseOutputStream);
        responseOutputStream.flush();
        responseOutputStream.close();
    }
}

