/*
 * Decompiled with CFR 0.152.
 */
package org.shept.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BeanUtilsExtended
extends BeanUtils {
    public static void mergeProperties(Object source, Object target) throws BeansException {
        BeanUtilsExtended.mergeProperties(source, target, null, null);
    }

    public static void mergeProperties(Object source, Object target, Class<?> editable) throws BeansException {
        BeanUtilsExtended.mergeProperties(source, target, editable, null);
    }

    private static void mergeProperties(Object source, Object target, Class<?> editable, String[] ignoreProperties) throws BeansException {
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        Class<?> actualEditable = target.getClass();
        if (editable != null) {
            if (!editable.isInstance(target)) {
                throw new IllegalArgumentException("Target class [" + target.getClass().getName() + "] not assignable to Editable class [" + editable.getName() + "]");
            }
            actualEditable = editable;
        }
        PropertyDescriptor[] targetPds = BeanUtilsExtended.getPropertyDescriptors(actualEditable);
        List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
        for (PropertyDescriptor targetPd : targetPds) {
            PropertyDescriptor sourcePd;
            if (targetPd.getWriteMethod() == null || ignoreProperties != null && ignoreList.contains(targetPd.getName()) || (sourcePd = BeanUtilsExtended.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || sourcePd.getReadMethod() == null) continue;
            try {
                Object value;
                Method readMethod = sourcePd.getReadMethod();
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                if ((value = readMethod.invoke(source, new Object[0])) == null) continue;
                Method writeMethod = targetPd.getWriteMethod();
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy properties from source to target", ex);
            }
        }
    }

    public static Map<String, ?> findNestedPaths(Object targetObject, Class<?> targetClass) throws Exception {
        return BeanUtilsExtended.findNestedPaths(targetObject, targetClass, new LinkedList<String>());
    }

    public static Map<String, ?> findNestedPaths(Object targetObject, Class<?> targetClass, List<String> ignoreList) throws Exception {
        HashSet<Object> visited = new HashSet<Object>();
        return BeanUtilsExtended.findNestedPaths(targetObject, targetClass, null, ignoreList, visited, 10);
    }

    public static Map<String, ?> findNestedPaths(Object targetObject, Class<?> targetClass, String nestedPath, List<String> ignoreList, Set<Object> visited, int maxDepth) throws Exception {
        PropertyDescriptor[] props;
        Assert.notNull((Object)targetObject);
        Assert.notNull(targetClass);
        Assert.notNull(ignoreList);
        HashMap<String, Object> nestedPaths = new HashMap<String, Object>();
        if (maxDepth <= 0) {
            return nestedPaths;
        }
        nestedPath = nestedPath == null ? "" : nestedPath;
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)targetObject);
        for (PropertyDescriptor pd : props = bw.getPropertyDescriptors()) {
            Class<?> clazz = pd.getPropertyType();
            if (clazz == null || clazz.equals(Class.class) || clazz.isAnnotation() || clazz.isPrimitive()) continue;
            Object value = null;
            String pathName = pd.getName();
            if (ignoreList.contains(pathName)) continue;
            try {
                value = bw.getPropertyValue(pathName);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (StringUtils.hasText((String)nestedPath)) {
                pathName = nestedPath + "." + pathName;
            }
            if (targetClass.isAssignableFrom(clazz)) {
                nestedPaths.put(pathName, value);
            }
            if (value == null || BeanUtilsExtended.isInstanceVisited(visited, value)) continue;
            nestedPaths.putAll(BeanUtilsExtended.findNestedPaths(value, targetClass, pathName, ignoreList, visited, maxDepth - 1));
        }
        return nestedPaths;
    }

    private static boolean isInstanceVisited(Collection coll, Object value) throws Exception {
        for (Object v : coll) {
            if (!v.equals(value)) continue;
            return true;
        }
        coll.add(value);
        return false;
    }
}

