/*
 * Decompiled with CFR 0.152.
 */
package org.shept.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class CommandShellExecute
implements Runnable {
    protected String cmdString;
    protected String[] envp = null;
    protected File workingDirectory = null;
    private boolean isRunning = false;
    private Integer exitVal = -1;
    private static final Log log = LogFactory.getLog(CommandShellExecute.class);

    public static String[] getEnvironment(String[] addEnv) {
        ArrayList<String> list = new ArrayList<String>();
        Map<String, String> sysEnv = System.getenv();
        for (Map.Entry<String, String> entry : sysEnv.entrySet()) {
            list.add(entry.getKey() + "=" + entry.getValue());
        }
        if (addEnv != null) {
            list.addAll(Arrays.asList(addEnv));
        }
        String[] res = new String[list.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (String)list.get(i);
        }
        return res;
    }

    public CommandShellExecute() {
    }

    public CommandShellExecute(String cmdString) {
        this.cmdString = cmdString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String[] cmd = new String[3];
        Assert.notNull((Object)this.cmdString);
        try {
            this.isRunning = true;
            this.exitVal = -1;
            String osName = System.getProperty("os.name");
            if (osName.equals("Windows 95")) {
                cmd[0] = "command.com";
                cmd[1] = "/C";
                cmd[2] = this.cmdString;
            } else if (osName.startsWith("Windows")) {
                cmd[0] = "cmd.exe";
                cmd[1] = "/C";
                cmd[2] = this.cmdString;
            } else if (osName.startsWith("Linux")) {
                cmd[0] = "/bin/bash";
                cmd[1] = "-c";
                cmd[2] = this.cmdString;
            } else {
                log.error((Object)("Unsupported operating system " + osName + " for command processing:  " + this.cmdString));
            }
            Runtime rt = Runtime.getRuntime();
            log.info((Object)("Executing " + cmd[0] + " " + cmd[1] + " " + cmd[2]));
            Process proc = rt.exec(cmd, this.envp, this.workingDirectory);
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), true);
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), false);
            errorGobbler.start();
            outputGobbler.start();
            this.exitVal = proc.waitFor();
            log.info((Object)("Result: " + this.exitVal.toString()));
        }
        catch (Throwable t) {
            log.error((Object)("Execution Error: " + cmd[0] + " " + cmd[1] + " " + cmd[2]), t);
        }
        finally {
            this.isRunning = false;
        }
    }

    public Integer getExitVal() {
        return this.exitVal;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setEnvp(String[] envp) {
        this.envp = envp;
    }

    public void setEnvpAdd(String[] envp) {
        this.setEnvp(CommandShellExecute.getEnvironment(envp));
    }

    public void setCmdString(String cmdString) {
        this.cmdString = cmdString;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    class StreamGobbler
    extends Thread {
        InputStream is;
        Boolean err;

        StreamGobbler(InputStream is, Boolean error) {
            this.is = is;
            this.err = error;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (this.err.booleanValue()) {
                        log.error((Object)line);
                        continue;
                    }
                    log.info((Object)line);
                }
            }
            catch (IOException ioe) {
                log.error((Object)"Error", (Throwable)ioe);
            }
        }
    }
}

