/*
 * Decompiled with CFR 0.152.
 */
package org.shept.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.shept.util.FileNameDate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

public class FileUtils {
    private static final Log log = LogFactory.getLog(FileUtils.class);

    public static SortedMap<FileNameDate, File> fileMapByNameAndDate(String path, String filePattern) {
        FileUtils fu = new FileUtils();
        TreeMap<FileNameDate, File> newFileMap = new TreeMap<FileNameDate, File>();
        File fileDir = new File(path);
        if (null != path && fileDir.isDirectory()) {
            FileUtils fileUtils = fu;
            fileUtils.getClass();
            Filter filter = fileUtils.new Filter(path, filePattern);
            File[] files = fileDir.listFiles(filter);
            for (int i = 0; i < files.length; ++i) {
                FileNameDate fk = new FileNameDate(files[i].getName(), files[i].lastModified());
                newFileMap.put(fk, files[i]);
            }
        }
        return newFileMap;
    }

    public static SortedMap<Calendar, File> fileMapByDate(String path, String filePattern) {
        FileUtils fu = new FileUtils();
        TreeMap<Calendar, File> newFileMap = new TreeMap<Calendar, File>();
        File fileDir = new File(path);
        if (null != path && fileDir.isDirectory()) {
            FileUtils fileUtils = fu;
            fileUtils.getClass();
            Filter filter = fileUtils.new Filter(path, filePattern);
            File[] files = fileDir.listFiles(filter);
            for (int i = 0; i < files.length; ++i) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(files[i].lastModified());
                newFileMap.put(cal, files[i]);
            }
        }
        return newFileMap;
    }

    public static SortedMap<Calendar, File> fileMapByFilenameDate(String path, String filePattern) {
        FileUtils fu = new FileUtils();
        TreeMap<Calendar, File> newFileMap = new TreeMap<Calendar, File>();
        File fileDir = new File(path);
        if (null != path && fileDir.isDirectory()) {
            FileUtils fileUtils = fu;
            fileUtils.getClass();
            Filter filter = fileUtils.new Filter(path, filePattern);
            File[] files = fileDir.listFiles(filter);
            for (int i = 0; i < files.length; ++i) {
                Calendar cal = Calendar.getInstance();
                String[] split = files[i].getName().split("_");
                int j = 0;
                while (!Character.isDigit(split[j].charAt(0))) {
                    ++j;
                }
                try {
                    cal.set(1, Integer.valueOf(split[j++]));
                    cal.set(2, Integer.valueOf(split[j++]) - 1);
                    cal.set(5, Integer.valueOf(split[j++]));
                    cal.set(11, Integer.valueOf(split[j].substring(0, 2)));
                    cal.set(12, Integer.valueOf(split[j].substring(2, 4)));
                    newFileMap.put(cal, files[i]);
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        return newFileMap;
    }

    public static Integer syncAdd(String sourcePath, String destPath, String filePattern) {
        Integer number = 0;
        SortedMap<FileNameDate, File> destMap = FileUtils.fileMapByNameAndDate(destPath, filePattern);
        SortedMap<FileNameDate, File> sourceMap = FileUtils.fileMapByNameAndDate(sourcePath, filePattern);
        for (FileNameDate fk : destMap.keySet()) {
            sourceMap.remove(fk);
        }
        for (File file : sourceMap.values()) {
            log.debug((Object)(file.getName() + ": " + new Date(file.lastModified())));
            File copy = new File(destPath, file.getName());
            try {
                if (copy.exists()) continue;
                File tmp = File.createTempFile("vrs", ".tmp", copy.getParentFile());
                FileCopyUtils.copy((File)file, (File)tmp);
                if (!tmp.renameTo(copy)) {
                    tmp.delete();
                }
                Integer n = number;
                Integer n2 = number = Integer.valueOf(number + 1);
            }
            catch (IOException ex) {
                log.error((Object)("FileCopy error for file " + file.getName()), (Throwable)ex);
            }
        }
        return number;
    }

    public static List<File> getDirectory(String dirPath, String filePattern) {
        FileUtils fu = new FileUtils();
        File fileDir = new File(dirPath);
        if (null == dirPath || !fileDir.isDirectory()) {
            return new ArrayList<File>();
        }
        FileUtils fileUtils = fu;
        fileUtils.getClass();
        Filter filter = fileUtils.new Filter(dirPath, filePattern);
        File[] files = fileDir.listFiles(filter);
        return CollectionUtils.arrayToList((Object)files);
    }

    public static List<File> getDirectory(String dirPath) {
        return FileUtils.getDirectory(dirPath, "*");
    }

    public static String getTomcatWebAppPath() {
        String path = System.getProperty("wtp.deploy");
        if (!StringUtils.hasText((String)path)) {
            path = System.getProperty("catalina.base");
            Assert.hasLength((String)path, (String)"Catalina (tomcat) installation base directory not found");
            path = path + "/webapps";
        }
        return path;
    }

    private class Filter
    implements FileFilter {
        String pattern = "*";
        String path = "";

        public Filter(String dirPath, String filePattern) {
            this.path = dirPath;
            this.pattern = filePattern;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return false;
            }
            if (!StringUtils.pathEquals((String)file.getParent(), (String)this.path)) {
                return false;
            }
            return PatternMatchUtils.simpleMatch((String)this.pattern, (String)file.getName());
        }
    }
}

