/*
 * Decompiled with CFR 0.152.
 */
package org.shept.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.shept.util.FileNameDate;
import org.shept.util.FileUtils;
import org.shept.util.FtpConfig;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

public class FtpFileCopy {
    private static final Log logger = LogFactory.getLog(FtpFileCopy.class);

    private boolean configSetup(FtpConfig config, FTPClient ftpC) throws IOException {
        int cwdCode;
        ftpC.connect(config.getHostAddress(), config.getPort());
        boolean rc = ftpC.login(config.getUserName(), config.getPassword());
        if (!rc) {
            logger.error((Object)("Ftp could not log to remote server with " + config.getUserName()));
            return false;
        }
        if (StringUtils.hasText((String)config.getServerPath()) && !FTPReply.isPositiveCompletion((int)(cwdCode = ftpC.cwd(config.getServerPath())))) {
            logger.error((Object)("Ftp could not change working dir to " + config.getServerPath() + " - Server returned Code " + cwdCode));
            return false;
        }
        rc = ftpC.setFileType(config.getFileType());
        if (!rc) {
            logger.error((Object)"Ftp could not change FileType for transmission");
            return false;
        }
        return true;
    }

    public int ftpSyncLocal(FtpConfig config, String localPath, String filePattern) {
        boolean rc = false;
        FTPClient ftpC = new FTPClient();
        int num = -1;
        try {
            rc = this.configSetup(config, ftpC);
            if (!rc) {
                return 0;
            }
            num = this.syncPull(ftpC, localPath, filePattern);
        }
        catch (Exception ex) {
            logger.error((Object)("Ftp preparing fileCopy did not succeed: " + config.toString()), (Throwable)ex);
        }
        try {
            ftpC.disconnect();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return num;
    }

    public int ftpSyncRemote(FtpConfig config, String remotePath, String filePattern) {
        boolean rc = false;
        FTPClient ftpC = new FTPClient();
        int num = -1;
        try {
            rc = this.configSetup(config, ftpC);
            if (!rc) {
                return 0;
            }
            num = this.syncPush(remotePath, ftpC, filePattern);
        }
        catch (Exception ex) {
            logger.error((Object)("Ftp preparing fileCopy did not succeed: " + config.toString()), (Throwable)ex);
        }
        try {
            ftpC.disconnect();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return num;
    }

    public Integer syncPull(FTPClient ftpSource, String localDestPat, String filePattern) throws IOException {
        Integer number = 0;
        SortedMap<FileNameDate, File> destMap = FileUtils.fileMapByNameAndDate(localDestPat, filePattern);
        SortedMap<FileNameDate, FTPFile> sourceMap = this.fileMapByNameAndDate(ftpSource, filePattern);
        for (FileNameDate fk : destMap.keySet()) {
            sourceMap.remove(fk);
        }
        for (FTPFile file : sourceMap.values()) {
            logger.debug((Object)("Copying file " + file.getName() + ": " + file.getTimestamp()));
            File copy = new File(localDestPat, file.getName());
            try {
                if (copy.exists()) continue;
                File tmp = File.createTempFile("vrs", ".tmp", copy.getParentFile());
                FileOutputStream writeStream = new FileOutputStream(tmp);
                boolean rc = ftpSource.retrieveFile(file.getName(), (OutputStream)writeStream);
                writeStream.close();
                if (rc) {
                    rc = tmp.renameTo(copy);
                    Integer n = number;
                    Integer n2 = number = Integer.valueOf(number + 1);
                }
                if (rc) continue;
                tmp.delete();
            }
            catch (IOException ex) {
                logger.error((Object)("Ftp FileCopy did not succeed (using " + file.getName() + ")" + " FTP reported error  " + ftpSource.getReplyString()), (Throwable)ex);
            }
        }
        return number;
    }

    public Integer syncPush(String localSourcePath, FTPClient ftpDest, String filePattern) throws IOException {
        Integer number = 0;
        SortedMap<FileNameDate, FTPFile> destMap = this.fileMapByNameAndDate(ftpDest, filePattern);
        SortedMap<FileNameDate, File> sourceMap = FileUtils.fileMapByNameAndDate(localSourcePath, filePattern);
        for (FileNameDate fk : destMap.keySet()) {
            sourceMap.remove(fk);
        }
        for (File file : sourceMap.values()) {
            logger.debug((Object)(file.getName() + ": " + new Date(file.lastModified())));
            try {
                if (ftpDest.listNames(file.getName()).length != 0) continue;
                FileInputStream fin = new FileInputStream(file);
                String tmpName = "tempFile";
                boolean rc = ftpDest.storeFile(tmpName, (InputStream)fin);
                fin.close();
                if (rc) {
                    rc = ftpDest.rename(tmpName, file.getName());
                    Integer n = number;
                    Integer n2 = number = Integer.valueOf(number + 1);
                }
                if (rc) continue;
                ftpDest.deleteFile(tmpName);
            }
            catch (Exception ex) {
                logger.error((Object)("Ftp FileCopy did not succeed (using " + file.getName() + ")" + " FTP reported error  " + ftpDest.getReplyString()));
            }
        }
        return number;
    }

    public SortedMap<FileNameDate, FTPFile> fileMapByNameAndDate(FTPClient ftp, String filePattern) throws IOException {
        FTPFile[] files;
        TreeMap<FileNameDate, FTPFile> newFileMap = new TreeMap<FileNameDate, FTPFile>();
        for (FTPFile ftpFile : files = ftp.listFiles()) {
            if (!this.acceptFile(ftpFile, filePattern)) continue;
            ftpFile.getTimestamp();
            FileNameDate fk = new FileNameDate(ftpFile.getName(), ftpFile.getTimestamp().getTimeInMillis());
            newFileMap.put(fk, ftpFile);
        }
        return newFileMap;
    }

    protected boolean acceptFile(FTPFile file, String pattern) {
        if (file.isDirectory()) {
            return false;
        }
        return PatternMatchUtils.simpleMatch((String)pattern, (String)file.getName());
    }

    private boolean ensureFtpDirectory(FTPClient ftpClient, String basePath, String path) throws IOException {
        ftpClient.changeWorkingDirectory(basePath);
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        while (tokenizer.hasMoreTokens()) {
            String folder = tokenizer.nextToken();
            FTPFile[] ftpFile = ftpClient.listFiles(folder);
            if (ftpFile.length == 0 && !ftpClient.makeDirectory(folder)) {
                logger.error((Object)("Ftp Creating the destination directory did not succeed " + ftpClient.getReplyString()));
                return false;
            }
            ftpClient.changeWorkingDirectory(folder);
        }
        return true;
    }
}

