/*
 * Decompiled with CFR 0.152.
 */
package org.shept.util;

import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.shept.util.JarUtils;
import org.shept.util.ResourceInitializer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StringUtils;

public class JarResourceCopier
implements ResourceInitializer {
    protected static final Log logger = LogFactory.getLog(JarResourceCopier.class);
    private String sourcePath;
    private String targetPath;
    private String[] files;

    @Override
    public void initializeResources(ServletContext context) {
        String destPath = StringUtils.cleanPath((String)context.getRealPath(this.getTargetPath()));
        if (this.files != null && this.files.length > 0) {
            for (int i = 0; i < this.files.length; ++i) {
                String source = StringUtils.applyRelativePath((String)this.getSourcePath(), (String)this.files[i]);
                JarUtils.copyResourcesOnce(new ClassPathResource(source), destPath, destPath + "/" + this.files[i]);
            }
        } else {
            JarUtils.copyResourcesOnce(new ClassPathResource(this.getSourcePath()), destPath);
        }
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public String[] getFiles() {
        return this.files;
    }

    public void setFiles(String[] files) {
        this.files = files;
    }
}

