/*
 * Decompiled with CFR 0.152.
 */
package org.shept.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ResourceUtils;

public abstract class JarUtils {
    private static Set<? super String> alreadyCopied = new HashSet<String>();
    protected static final Log logger = LogFactory.getLog(JarUtils.class);

    public static void copyResourcesOnce(ClassPathResource cpr, String destPath, String resName) {
        if (alreadyCopied.contains(resName)) {
            return;
        }
        try {
            JarUtils.copyResources(cpr, destPath);
        }
        catch (IOException ex) {
            logger.error((Object)("Could not copy required resources from " + cpr.getPath() + " to " + destPath), (Throwable)ex);
        }
        catch (URISyntaxException e) {
            logger.error((Object)("Could not copy required resources from " + cpr.getPath() + " to " + destPath), (Throwable)e);
        }
        alreadyCopied.add(resName);
    }

    public static void copyResourcesOnce(ClassPathResource cpr, String destPath) {
        JarUtils.copyResourcesOnce(cpr, destPath, destPath);
    }

    public static void copyResources(ClassPathResource cpr, String webAppDestPath) throws IOException, URISyntaxException {
        String dstPath = webAppDestPath;
        File dir = new File(dstPath);
        dir.mkdirs();
        URL url = cpr.getURL();
        URL jarUrl = ResourceUtils.extractJarFileURL((URL)url);
        String urlFile = url.getFile();
        String resPath = "";
        int separatorIndex = urlFile.indexOf("!/");
        if (separatorIndex == -1) {
            return;
        }
        resPath = urlFile.substring(separatorIndex + "!/".length());
        File f = new File(ResourceUtils.toURI((URL)jarUrl));
        JarFile jf = new JarFile(f);
        Enumeration<JarEntry> entries = jf.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String path = entry.getName();
            if (!path.startsWith(resPath) || entry.getSize() <= 0L) continue;
            String fileName = path.substring(path.lastIndexOf("/"));
            File dstFile = new File(dstPath, fileName);
            Resource fileRes = cpr.createRelative(fileName);
            if (dstFile.exists() || !fileRes.exists()) continue;
            FileOutputStream fos = new FileOutputStream(dstFile);
            FileCopyUtils.copy((InputStream)fileRes.getInputStream(), (OutputStream)fos);
            logger.info((Object)("Successfully copied file " + fileName + " from " + cpr.getPath() + " to " + dstFile.getPath()));
        }
        if (jf != null) {
            jf.close();
        }
    }

    public static void copyResources(String[] resources, ClassPathResource cpr, String webAppDestPath) throws IOException {
        String dstPath = webAppDestPath;
        File dir = new File(dstPath);
        dir.mkdirs();
        for (int i = 0; i < resources.length; ++i) {
            File dstFile = new File(dstPath, resources[i]);
            Resource fileRes = cpr.createRelative(resources[i]);
            if (dstFile.exists() || !fileRes.exists()) continue;
            FileOutputStream fos = new FileOutputStream(dstFile);
            FileCopyUtils.copy((InputStream)fileRes.getInputStream(), (OutputStream)fos);
            logger.info((Object)("Successfully copied file " + fileRes.getFilename() + " from " + cpr.getPath() + " to " + dstFile.getPath()));
        }
    }

    public static String jarPathInternal(URL jarPathUrl) {
        String urlFile = jarPathUrl.getFile();
        int separatorIndex = urlFile.indexOf("!/");
        if (separatorIndex != -1) {
            return urlFile.substring(separatorIndex += "!/".length(), urlFile.length());
        }
        return "";
    }

    public static Set<? super String> getAlreadyCopied() {
        return alreadyCopied;
    }
}

