/*
 * Decompiled with CFR 0.152.
 */
package org.shept.util;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Monitor {
    private static final Log log = LogFactory.getLog(Monitor.class);
    private boolean isMonitoring = false;
    private Date timestamp = new Date();
    private Integer monitorPort = 9876;
    private Integer hostPort = 9876;
    private String hostname = "localhost";
    private String sendMsg = "Ping";
    private String rcvMsg = "";
    private Integer lock = 0;
    private Integer msecsOfflineLatency = 10000;
    private Integer msecsSendTimeout = 2000;
    private Integer msecsRcvTimeout = 10000;
    private MonitorTask monitor = new MonitorTask();

    public Boolean keepAlive() {
        try {
            InetAddress adr = InetAddress.getByName(this.hostname);
            byte[] data = this.sendMsg.getBytes();
            DatagramSocket socket = new DatagramSocket();
            DatagramPacket pack = new DatagramPacket(data, data.length, adr, this.hostPort);
            socket.setSoTimeout(this.msecsSendTimeout);
            socket.send(pack);
            socket.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage() {
        Integer n = this.lock;
        synchronized (n) {
            return this.rcvMsg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getTimestamp() {
        Integer n = this.lock;
        synchronized (n) {
            return this.timestamp;
        }
    }

    public void setMonitoring(boolean isMonitoring) {
        if (isMonitoring && !this.monitor.isAlive()) {
            this.monitor = new MonitorTask();
            this.monitor.start();
        }
        this.isMonitoring = isMonitoring;
    }

    public void setMonitorPort(Integer port) {
        this.monitorPort = port;
    }

    public void setHostPort(Integer port) {
        this.hostPort = port;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setSendMsg(String sendMsg) {
        this.sendMsg = sendMsg;
    }

    public Boolean isAlive() {
        Long diff = new Date().getTime() - this.timestamp.getTime();
        return diff < (long)this.msecsOfflineLatency.intValue();
    }

    public Boolean isMonitoring() {
        return this.isMonitoring;
    }

    public void setMsecsOfflineLatency(Integer msecsOfflineLatency) {
        this.msecsOfflineLatency = msecsOfflineLatency;
    }

    public void setMsecsSendTimeout(Integer msecsSendTimeout) {
        this.msecsSendTimeout = msecsSendTimeout;
    }

    public void close() {
        this.isMonitoring = false;
    }

    private class MonitorTask
    extends Thread {
        private MonitorTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block18: {
                DatagramSocket sock = null;
                byte[] data = new byte[4096];
                while (true) {
                    try {
                        if (Monitor.this.isMonitoring) {
                            if (sock == null) {
                                sock = new DatagramSocket(Monitor.this.monitorPort);
                            }
                            DatagramPacket pack = new DatagramPacket(data, data.length);
                            sock.setSoTimeout(Monitor.this.msecsRcvTimeout);
                            try {
                                sock.receive(pack);
                                String rv = new String(data, 0, pack.getLength());
                                Integer n = Monitor.this.lock;
                                synchronized (n) {
                                    Monitor.this.timestamp = new Date();
                                    Monitor.this.rcvMsg = rv;
                                    continue;
                                }
                            }
                            catch (SocketTimeoutException timeEx) {
                                Monitor.this.rcvMsg = "";
                                continue;
                            }
                        }
                        break block18;
                    }
                    catch (SocketException ex) {
                        log.error((Object)("Monitoring Socket could not be bound to port " + Monitor.this.monitorPort));
                        break block18;
                    }
                    catch (Exception e) {
                        log.error((Object)("Exception while monitoring port " + Monitor.this.monitorPort), (Throwable)e);
                        break block18;
                    }
                }
                finally {
                    if (sock != null) {
                        sock.close();
                    }
                    sock = null;
                    Monitor.this.isMonitoring = false;
                }
            }
        }
    }
}

