/*
 * Decompiled with CFR 0.152.
 */
package org.shept.util;

import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;

public class SheptBeanFactoryUtils {
    public static String getParentBeanName(ApplicationContext ctx, String beanName) {
        BeanDefinition def;
        ApplicationContext pc = SheptBeanFactoryUtils.getRootContext(ctx);
        AutowireCapableBeanFactory factory = pc.getAutowireCapableBeanFactory();
        if (factory instanceof DefaultListableBeanFactory && (def = ((DefaultListableBeanFactory)factory).getBeanDefinition(beanName)) != null) {
            return def.getParentName();
        }
        return null;
    }

    public static ApplicationContext getRootContext(ApplicationContext ctx) {
        if (ctx.getParent() == null) {
            return ctx;
        }
        return ctx.getParent();
    }
}

