/*
 * Decompiled with CFR 0.152.
 */
package org.sikongsphere.geomesa;

import java.io.IOException;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.utils.interop.SimpleFeatureTypes;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class SimpleFeatureWriter {
    private FeatureWriter<SimpleFeatureType, SimpleFeature> writer;

    public SimpleFeatureType mkSimpleFeatureType(String simpleFeatureTypeName, String simpleFeatureTypeField) {
        SimpleFeatureType sft = SimpleFeatureTypes.createType((String)simpleFeatureTypeName, (String)simpleFeatureTypeField);
        sft.getUserData().put(SimpleFeatureTypes.DEFAULT_DATE_KEY, "dtg");
        return sft;
    }

    public void writeFeature(DataStore dataStore, SimpleFeatureType sft, SimpleFeature feature) throws IOException {
        this.writer = dataStore.getFeatureWriterAppend(sft.getTypeName(), Transaction.AUTO_COMMIT);
        SimpleFeature toWrite = (SimpleFeature)this.writer.next();
        toWrite.setAttributes(feature.getAttributes());
        ((FeatureIdImpl)toWrite.getIdentifier()).setID(feature.getID());
        toWrite.getUserData().put(Hints.USE_PROVIDED_FID, Boolean.TRUE);
        toWrite.getUserData().putAll(feature.getUserData());
        this.writer.write();
    }

    public void writeClose() throws IOException {
        this.writer.close();
    }
}

