/*
 * Decompiled with CFR 0.152.
 */
package org.sikongsphere.ifc;

import java.util.HashMap;
import java.util.List;
import org.sikongsphere.ifc.model.datatype.INTEGER;
import org.sikongsphere.ifc.model.fileelement.IfcFileModel;
import org.sikongsphere.ifc.model.schema.extension.product.entities.IfcSite;
import org.sikongsphere.ifc.sdk.SikongSphereSession;
import org.sikongsphere.ifc.sdk.convert.IfcModelConvertor;
import org.sikongsphere.ifc.sdk.query.IfcModelQuery;

public class IfcLonLatParser {
    private Double convertToDegree(Integer degrees, Integer minutes, Integer seconds, Integer milliseconds) {
        double decimalMinutes = (double)minutes.intValue() / 60.0;
        double decimalSeconds = (double)seconds.intValue() / 3600.0;
        double decimalMilliseconds = (double)milliseconds.intValue() / 3600000.0;
        return (double)degrees.intValue() + decimalMinutes + decimalSeconds + decimalMilliseconds;
    }

    private IfcSite getIfcSite(String ifcFile) {
        SikongSphereSession session = SikongSphereSession.getOrCreate();
        IfcModelConvertor convertor = (IfcModelConvertor)session.convertor(IfcFileModel.class);
        IfcFileModel model = convertor.readFile(ifcFile);
        IfcModelQuery query = (IfcModelQuery)session.query(IfcFileModel.class);
        List objects = query.filterByClass(model, IfcSite.class);
        return (IfcSite)objects.get(0);
    }

    public static HashMap<String, Double> parse(String ifcFile) {
        IfcLonLatParser parser = new IfcLonLatParser();
        IfcSite ifcSite = parser.getIfcSite(ifcFile);
        List refLatitude = ifcSite.getRefLatitude().getObjects();
        List refLongitude = ifcSite.getRefLongitude().getObjects();
        Double latitude = parser.convertToDegree(((INTEGER)refLatitude.get((int)0)).value, ((INTEGER)refLatitude.get((int)1)).value, ((INTEGER)refLatitude.get((int)2)).value, ((INTEGER)refLatitude.get((int)3)).value);
        Double longitude = parser.convertToDegree(((INTEGER)refLongitude.get((int)0)).value, ((INTEGER)refLongitude.get((int)1)).value, ((INTEGER)refLongitude.get((int)2)).value, ((INTEGER)refLongitude.get((int)3)).value);
        HashMap<String, Double> coordination = new HashMap<String, Double>();
        coordination.put("latitude", latitude);
        coordination.put("longitude", longitude);
        return coordination;
    }
}

