/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.hello_sila;

import com.google.common.collect.ImmutableMap;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.CloudClientEndpointGrpc;
import sila_java.examples.hello_sila.CloudHelloSiLAServer;
import sila_java.examples.hello_sila.HelloSiLAServer;
import sila_java.examples.hello_sila.SayHelloCommand;
import sila_java.library.cloudier.server.CloudierConnectionConfigurationService;
import sila_java.library.cloudier.server.CloudierServerEndpoint;
import sila_java.library.cloudier.server.CloudierSiLAService;
import sila_java.library.core.sila.clients.ChannelFactory;
import sila_java.library.core.utils.FileUtils;
import sila_java.library.core.utils.Utils;
import sila_java.library.sila_base.EmptyClass;

public class CloudHelloSiLAServer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(CloudHelloSiLAServer.class);
    private final CloudierSiLAService cloudierSiLAService;
    private final CloudierConnectionConfigurationService cloudierConnectionConfigurationService;
    private CloudClientEndpointGrpc.CloudClientEndpointStub clientEndpoint;
    private CloudierServerEndpoint cloudServerEndpointService;
    private ManagedChannel channel;

    public static void main(String[] args) throws IOException {
        UUID serverUUID = UUID.randomUUID();
        CloudHelloSiLAServer cloudHelloSiLAServer = new CloudHelloSiLAServer(serverUUID);
        log.info("To stop the server press CTRL + C.");
        Utils.blockUntilShutdown(() -> cloudHelloSiLAServer.close());
    }

    public CloudHelloSiLAServer(UUID serverUUID) throws IOException {
        ImmutableMap immutableMap = ImmutableMap.builder().put((Object)"SiLAService", (Object)FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/core/SiLAService-v1_0.sila.xml")))).put((Object)"ConnectionConfigurationService", (Object)FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/core/ConnectionConfigurationService-v1_0.sila.xml")))).put((Object)"GreetingProvider", (Object)FileUtils.getFileContent((InputStream)EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/examples/GreetingProvider-v1_0.sila.xml"))).build();
        this.cloudierSiLAService = new CloudierSiLAService("Cloud Hello SiLA Server", HelloSiLAServer.serverInfo.getType(), serverUUID.toString(), HelloSiLAServer.serverInfo.getVersion(), HelloSiLAServer.serverInfo.getDescription(), HelloSiLAServer.serverInfo.getVendorURL(), (Map)immutableMap);
        this.cloudierConnectionConfigurationService = new CloudierConnectionConfigurationService(false, connectionMode -> {});
        this.startServerInitiatedConnection();
    }

    private void startServerInitiatedConnection() {
        this.channel = ChannelFactory.getTLSEncryptedChannel((String)"127.0.0.1", (int)50051);
        this.clientEndpoint = CloudClientEndpointGrpc.newStub((Channel)this.channel);
        SayHelloCommand helloCommand = new SayHelloCommand();
        1 callForwarderMap = new /* Unavailable Anonymous Inner Class!! */;
        this.cloudServerEndpointService = new CloudierServerEndpoint(this.cloudierSiLAService, this.cloudierConnectionConfigurationService, this.clientEndpoint, (Map)callForwarderMap);
    }

    @Override
    public void close() {
        this.channel.shutdown();
    }
}

