/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.hello_sila;

import io.grpc.BindableService;
import java.io.IOException;
import java.io.InputStream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.examples.hello_sila.SayHelloCommand;
import sila_java.library.core.utils.FileUtils;
import sila_java.library.server_base.SiLAServer;
import sila_java.library.server_base.identification.ServerInformation;
import sila_java.library.server_base.utils.ArgumentHelper;
import sila_java.library.sila_base.EmptyClass;

public class HelloSiLAServer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(HelloSiLAServer.class);
    public static final String SERVER_TYPE = "HelloSiLAServer";
    private final SiLAServer server;
    public static final ServerInformation serverInfo = new ServerInformation("HelloSiLAServer", "Simple Example of a SiLA Server", "https://www.sila-standard.org", "0.0");

    HelloSiLAServer(@NonNull ArgumentHelper argumentHelper) {
        if (argumentHelper == null) {
            throw new NullPointerException("argumentHelper is marked non-null but is null");
        }
        try {
            SiLAServer.Builder builder = SiLAServer.Builder.newBuilder((ServerInformation)serverInfo);
            builder.withPersistentConfig(argumentHelper.getConfigFile().isPresent());
            argumentHelper.getConfigFile().ifPresent(arg_0 -> ((SiLAServer.Builder)builder).withPersistentConfigFile(arg_0));
            builder.withPersistentTLS(argumentHelper.getPrivateKeyFile(), argumentHelper.getCertificateFile(), argumentHelper.getCertificatePassword());
            if (argumentHelper.useUnsafeCommunication()) {
                builder.withUnsafeCommunication(true);
            }
            argumentHelper.getHost().ifPresent(arg_0 -> ((SiLAServer.Builder)builder).withHost(arg_0));
            argumentHelper.getPort().ifPresent(arg_0 -> ((SiLAServer.Builder)builder).withPort(arg_0));
            argumentHelper.getInterface().ifPresent(arg_0 -> ((SiLAServer.Builder)builder).withNetworkInterface(arg_0));
            builder.withDiscovery(argumentHelper.hasNetworkDiscovery());
            builder.addFeature(FileUtils.getFileContent((InputStream)EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/examples/GreetingProvider-v1_0.sila.xml")), (BindableService)new SayHelloCommand());
            this.server = builder.start();
        }
        catch (IOException e) {
            log.error("Something went wrong when building / starting server", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.server.close();
    }

    public static void main(String[] args) {
        ArgumentHelper argumentHelper = new ArgumentHelper(args, SERVER_TYPE);
        HelloSiLAServer helloSiLAServer = new HelloSiLAServer(argumentHelper);
        log.info("To stop the server press CTRL + C.");
        helloSiLAServer.server.blockUntilShutdown();
        log.info("termination complete.");
    }
}

