/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.hello_sila;

import io.grpc.BindableService;
import java.io.IOException;
import java.nio.file.Path;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.examples.hello_sila.SayHelloCommand;
import sila_java.library.core.utils.FileUtils;
import sila_java.library.core.utils.Utils;
import sila_java.library.server_base.SiLAServer;
import sila_java.library.server_base.identification.ServerInformation;
import sila_java.library.server_base.utils.ArgumentHelper;

public class HelloSiLAServer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(HelloSiLAServer.class);
    public static final String SERVER_TYPE = "Hello SiLA Server";
    private final SiLAServer server;
    public static final ServerInformation serverInfo = new ServerInformation("Hello SiLA Server", "Simple Example of a SiLA Server", "www.sila-standard.org", "v0.0");

    HelloSiLAServer(@NonNull ArgumentHelper argumentHelper) {
        if (argumentHelper == null) {
            throw new NullPointerException("argumentHelper is marked non-null but is null");
        }
        try {
            SiLAServer.Builder builder = argumentHelper.getConfigFile().isPresent() ? SiLAServer.Builder.withConfig((Path)((Path)argumentHelper.getConfigFile().get()), (ServerInformation)serverInfo) : SiLAServer.Builder.withoutConfig((ServerInformation)serverInfo);
            builder.withPersistedTLS(argumentHelper.getPrivateKeyFile(), argumentHelper.getCertificateFile(), argumentHelper.getCertificatePassword());
            if (argumentHelper.useUnsafeCommunication()) {
                builder.withUnsafeCommunication(true);
            }
            argumentHelper.getPort().ifPresent(arg_0 -> ((SiLAServer.Builder)builder).withPort(arg_0));
            argumentHelper.getInterface().ifPresent(arg_0 -> ((SiLAServer.Builder)builder).withDiscovery(arg_0));
            builder.addFeature(FileUtils.getResourceContent((String)"GreetingProvider.sila.xml"), (BindableService)new SayHelloCommand());
            this.server = builder.start();
        }
        catch (IOException e) {
            log.error("Something went wrong when building / starting server", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.server.close();
    }

    public static void main(String[] args) {
        ArgumentHelper argumentHelper = new ArgumentHelper(args, SERVER_TYPE);
        try (HelloSiLAServer helloSiLAServer = new HelloSiLAServer(argumentHelper);){
            Runtime.getRuntime().addShutdownHook(new Thread(() -> helloSiLAServer.close()));
            Utils.blockUntilStop();
        }
        log.info("termination complete.");
    }
}

