/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.hello_sila;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.StatusRuntimeException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.core.silaservice.v1.SiLAServiceGrpc;
import sila2.org.silastandard.core.silaservice.v1.SiLAServiceOuterClass;
import sila2.org.silastandard.examples.greetingprovider.v1.GreetingProviderGrpc;
import sila2.org.silastandard.examples.greetingprovider.v1.GreetingProviderOuterClass;
import sila_java.library.core.sila.clients.ChannelFactory;
import sila_java.library.core.sila.errors.ExceptionGeneration;
import sila_java.library.core.sila.types.SiLAString;
import sila_java.library.manager.ServerFinder;
import sila_java.library.manager.ServerManager;
import sila_java.library.manager.models.Server;

public class HelloSiLAClient {
    private static final Logger log = LoggerFactory.getLogger(HelloSiLAClient.class);
    private GreetingProviderGrpc.GreetingProviderBlockingStub blockingStub;

    private void buildStub(ManagedChannel channel) {
        this.blockingStub = GreetingProviderGrpc.newBlockingStub((Channel)channel);
    }

    private void greet(String name) {
        GreetingProviderOuterClass.Get_StartYear_Responses startYear;
        GreetingProviderOuterClass.SayHello_Responses result;
        System.out.println("Will try to greet " + name + " ...");
        GreetingProviderOuterClass.SayHello_Parameters.Builder parameter = GreetingProviderOuterClass.SayHello_Parameters.newBuilder();
        try {
            result = this.blockingStub.sayHello(parameter.setName(SiLAString.from((String)name)).build());
        }
        catch (StatusRuntimeException e) {
            log.error(ExceptionGeneration.generateMessage((Throwable)e));
            return;
        }
        System.out.println("Greeting: " + result.getGreeting().getValue());
        System.out.println("Will try to get start year...");
        try {
            startYear = this.blockingStub.getStartYear(GreetingProviderOuterClass.Get_StartYear_Parameters.newBuilder().build());
        }
        catch (StatusRuntimeException e) {
            log.error(ExceptionGeneration.generateMessage((Throwable)e));
            return;
        }
        System.out.println("Start Year: " + startYear.getStartYear());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try (ServerManager serverManager = ServerManager.getInstance();){
            HelloSiLAClient client = new HelloSiLAClient();
            Server server = (Server)ServerFinder.filterBy((ServerFinder.Filter[])new ServerFinder.Filter[]{ServerFinder.Filter.type((String)"Hello SiLA Server")}).scanAndFindOne(Duration.ofMinutes(1L)).orElseThrow(() -> new RuntimeException("No HelloSiLA server found within time"));
            log.info("Found Server!");
            ManagedChannel serviceChannel = ChannelFactory.getTLSEncryptedChannel((String)server.getHost(), (int)server.getPort(), (String)server.getCertificateAuthority());
            try {
                SiLAServiceGrpc.SiLAServiceBlockingStub serviceStub = SiLAServiceGrpc.newBlockingStub((Channel)serviceChannel);
                System.out.println("Found Features:");
                List featureIdentifierList = serviceStub.getImplementedFeatures(SiLAServiceOuterClass.Get_ImplementedFeatures_Parameters.newBuilder().build()).getImplementedFeaturesList();
                featureIdentifierList.forEach(featureIdentifier -> System.out.println("\t" + featureIdentifier.getValue()));
                client.buildStub(serviceChannel);
                String user = "SiLA";
                client.greet(user);
            }
            finally {
                serviceChannel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
            }
        }
    }
}

