/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.metadata;

import com.google.protobuf.Message;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.StatusRuntimeException;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.core.authorizationservice.v1.AuthorizationServiceOuterClass;
import sila2.org.silastandard.examples.greetingprovider.v1.GreetingProviderGrpc;
import sila2.org.silastandard.examples.greetingprovider.v1.GreetingProviderOuterClass;
import sila_java.library.core.sila.clients.ChannelFactory;
import sila_java.library.core.sila.errors.SiLAErrors;
import sila_java.library.core.sila.types.SiLAString;
import sila_java.library.core.sila.utils.MetadataUtils;

public class Client {
    private static final Logger log = LoggerFactory.getLogger(Client.class);
    private final GreetingProviderGrpc.GreetingProviderBlockingStub greetingProviderStub;

    public Client(int port) {
        ManagedChannel channel = ChannelFactory.getUnencryptedChannel((String)"127.0.0.1", (int)port);
        this.greetingProviderStub = GreetingProviderGrpc.newBlockingStub((Channel)channel);
    }

    public String sayHello(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.sayHello(this.greetingProviderStub, name);
    }

    public String sayHelloWithAccessToken(@NonNull String name, @NonNull String accessToken) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        AuthorizationServiceOuterClass.Metadata_AccessToken accessTokenMessage = AuthorizationServiceOuterClass.Metadata_AccessToken.newBuilder().setAccessToken(SiLAString.from((String)accessToken)).build();
        GreetingProviderGrpc.GreetingProviderBlockingStub stubWithToken = (GreetingProviderGrpc.GreetingProviderBlockingStub)this.greetingProviderStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newMetadataInjector((Message[])new Message[]{accessTokenMessage})});
        return this.sayHello(stubWithToken, name);
    }

    private String sayHello(@NonNull GreetingProviderGrpc.GreetingProviderBlockingStub stub, @NonNull String name) {
        if (stub == null) {
            throw new NullPointerException("stub is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        GreetingProviderOuterClass.SayHello_Parameters request = GreetingProviderOuterClass.SayHello_Parameters.newBuilder().setName(SiLAString.from((String)name)).build();
        GreetingProviderOuterClass.SayHello_Responses response = stub.sayHello(request);
        return response.getGreeting().getValue();
    }

    public static void main(String[] args) {
        String response;
        Client client = new Client(50052);
        try {
            response = client.sayHello("World");
            log.info("Got response: " + response);
        }
        catch (StatusRuntimeException e) {
            log.info("Caught error: " + SiLAErrors.retrieveSiLAError((StatusRuntimeException)e));
        }
        try {
            response = client.sayHelloWithAccessToken("World", "invalid-token");
            log.info("Got response: " + response);
        }
        catch (StatusRuntimeException e) {
            log.info("Caught error: " + SiLAErrors.retrieveSiLAError((StatusRuntimeException)e));
        }
        try {
            response = client.sayHelloWithAccessToken("World", "secret-access-token");
            log.info("Got response: " + response);
        }
        catch (StatusRuntimeException e) {
            log.info("Caught error: " + SiLAErrors.retrieveSiLAError((StatusRuntimeException)e));
        }
    }
}

