/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.metadata;

import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import sila_java.examples.metadata.AuthorizationServiceImpl;
import sila_java.examples.metadata.GreetingProviderImpl;
import sila_java.library.core.utils.FileUtils;
import sila_java.library.server_base.SiLAServer;
import sila_java.library.server_base.identification.ServerInformation;
import sila_java.library.sila_base.EmptyClass;

public class Server
implements AutoCloseable {
    private final SiLAServer silaServer;

    public Server(int port) throws IOException {
        ServerInformation serverInformation = new ServerInformation("MetadataExampleServer", "Server to demonstrate SiLA Client Metadata using the Authorization Service feature", "https://gitlab.com/SiLA2/sila_java", "0.1");
        AuthorizationServiceImpl authorizationService = new AuthorizationServiceImpl("secret-access-token", Collections.singletonList("org.silastandard/examples/GreetingProvider/v1"));
        this.silaServer = SiLAServer.Builder.newBuilder((ServerInformation)serverInformation).addFeature(FileUtils.getFileContent((InputStream)EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/core/AuthorizationService-v1_0.sila.xml")), (BindableService)authorizationService).addInterceptor((ServerInterceptor)authorizationService.accessTokenInterceptor).addFeature(FileUtils.getFileContent((InputStream)EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/examples/GreetingProvider-v1_0.sila.xml")), (BindableService)new GreetingProviderImpl()).withUnsafeCommunication(true).withPort(port).start();
    }

    @Override
    public void close() {
        this.silaServer.close();
    }

    public static void main(String[] args) throws IOException {
        Server server = new Server(50052);
        server.silaServer.blockUntilShutdown();
    }
}

