/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.metadata;

import io.grpc.Context;
import io.grpc.ServerCall;
import io.grpc.stub.StreamObserver;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLAFramework;
import sila2.org.silastandard.core.authorizationservice.v1.AuthorizationServiceGrpc;
import sila2.org.silastandard.core.authorizationservice.v1.AuthorizationServiceOuterClass;
import sila_java.library.core.sila.errors.SiLAErrors;
import sila_java.library.core.sila.types.SiLAString;
import sila_java.library.server_base.metadata.MetadataInterceptor;
import sila_java.library.server_base.metadata.ServerMetadataContainer;

class AuthorizationServiceImpl
extends AuthorizationServiceGrpc.AuthorizationServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationServiceImpl.class);
    private final String validAccessToken;
    private final List<String> affectedCalls;
    public final MetadataInterceptor accessTokenInterceptor;

    AuthorizationServiceImpl(String validAccessToken, List<String> affectedCalls) {
        this.validAccessToken = validAccessToken;
        this.affectedCalls = affectedCalls;
        this.accessTokenInterceptor = new AccessTokenInterceptor(affectedCalls);
    }

    @Override
    public void getFCPAffectedByMetadataAccessToken(AuthorizationServiceOuterClass.Get_FCPAffectedByMetadata_AccessToken_Parameters request, StreamObserver<AuthorizationServiceOuterClass.Get_FCPAffectedByMetadata_AccessToken_Responses> responseObserver) {
        AuthorizationServiceOuterClass.Get_FCPAffectedByMetadata_AccessToken_Responses.Builder responseBuilder = AuthorizationServiceOuterClass.Get_FCPAffectedByMetadata_AccessToken_Responses.newBuilder();
        this.affectedCalls.forEach(affectedCall -> responseBuilder.addAffectedCalls(SiLAString.from((String)affectedCall)));
        responseObserver.onNext((Object)responseBuilder.build());
        responseObserver.onCompleted();
    }

    private class AccessTokenInterceptor
    extends MetadataInterceptor {
        public AccessTokenInterceptor(List<String> affectedCalls) {
            super(affectedCalls);
            if (affectedCalls == null) {
                throw new NullPointerException("affectedCalls is marked non-null but is null");
            }
        }

        public AccessTokenInterceptor(String affectedCall) {
            super(affectedCall);
            if (affectedCall == null) {
                throw new NullPointerException("affectedCall is marked non-null but is null");
            }
        }

        public <ReqT, RespT> Context intercept(ServerCall<ReqT, RespT> call, ServerMetadataContainer metadata) {
            AuthorizationServiceOuterClass.Metadata_AccessToken accessTokenMessage = (AuthorizationServiceOuterClass.Metadata_AccessToken)metadata.get(AuthorizationServiceOuterClass.Metadata_AccessToken.class);
            if (accessTokenMessage == null) {
                throw SiLAErrors.generateFrameworkError((SiLAFramework.FrameworkError.ErrorType)SiLAFramework.FrameworkError.ErrorType.INVALID_METADATA, (String)"No access token metadata received (org.silastandard/core/AuthorizationService/v1/Metadata/AccessToken)");
            }
            if (!accessTokenMessage.hasAccessToken()) {
                throw SiLAErrors.generateFrameworkError((SiLAFramework.FrameworkError.ErrorType)SiLAFramework.FrameworkError.ErrorType.INVALID_METADATA, (String)"Received lock identifier message was empty (org.silastandard/core/AuthorizationService/v1/Metadata/AccessToken)");
            }
            String accessToken = accessTokenMessage.getAccessToken().getValue();
            if (!accessToken.equals(AuthorizationServiceImpl.this.validAccessToken)) {
                throw SiLAErrors.generateDefinedExecutionError((String)"org.silastandard/core/AuthorizationService/v1/DefinedExecutionError/InvalidAccessToken", (String)"Invalid access token");
            }
            return Context.current();
        }
    }
}

