/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.test_server.utils;

import java.io.IOException;
import java.io.InputStream;

public class ByteArrayProcessedInputStream
extends InputStream {
    private final InputStream in;
    private final ApplyOnBytes applyOnBytes;

    @Override
    public int read() throws IOException {
        int singleByte = this.in.read();
        if (singleByte == -1) {
            return -1;
        }
        byte[] singleByteArray = new byte[]{(byte)singleByte};
        this.applyOnBytes.apply(singleByteArray, 0, 1);
        return singleByteArray[0];
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.in.read(b);
        if (read == -1) {
            return -1;
        }
        this.applyOnBytes.apply(b, 0, read);
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        if (read == -1) {
            return -1;
        }
        this.applyOnBytes.apply(b, off, read);
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    public ByteArrayProcessedInputStream(InputStream in, ApplyOnBytes applyOnBytes) {
        this.in = in;
        this.applyOnBytes = applyOnBytes;
    }

    @FunctionalInterface
    public static interface ApplyOnBytes {
        public void apply(byte[] var1, int var2, int var3);
    }
}

