/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.test_server;

import com.google.common.collect.ImmutableMap;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.ch.unitelabs.test.observablecommandtest.v1.ObservableCommandTestOuterClass;
import sila2.ch.unitelabs.test.observablepropertytest.v1.ObservablePropertyTestOuterClass;
import sila2.ch.unitelabs.test.parameterconstraintsprovidertest.v1.ParameterConstraintsProviderTestOuterClass;
import sila2.ch.unitelabs.test.unobservablecommandtest.v1.UnobservableCommandTestOuterClass;
import sila2.org.silastandard.BinaryDownloadGrpc;
import sila2.org.silastandard.BinaryUploadGrpc;
import sila2.org.silastandard.CloudClientEndpointGrpc;
import sila2.org.silastandard.SiLAFramework;
import sila2.org.silastandard.core.commands.parameterconstraintsprovider.v1.ParameterConstraintsProviderGrpc;
import sila2.org.silastandard.core.commands.parameterconstraintsprovider.v1.ParameterConstraintsProviderOuterClass;
import sila_java.examples.test_server.TestServer;
import sila_java.examples.test_server.impl.ObservableCommand;
import sila_java.examples.test_server.impl.ObservableProperty;
import sila_java.examples.test_server.impl.ParameterConstraintsProvider;
import sila_java.examples.test_server.impl.UnobservableCommand;
import sila_java.library.cloudier.server.CloudierConnectionConfigurationService;
import sila_java.library.cloudier.server.CloudierServerEndpoint;
import sila_java.library.cloudier.server.CloudierSiLAService;
import sila_java.library.cloudier.server.MessageCaseHandler;
import sila_java.library.core.sila.clients.ChannelFactory;
import sila_java.library.core.utils.FileUtils;
import sila_java.library.core.utils.Utils;
import sila_java.library.server_base.binary_transfer.database.BinaryDatabase;
import sila_java.library.server_base.binary_transfer.database.impl.H2BinaryDatabase;
import sila_java.library.server_base.binary_transfer.download.DownloadService;
import sila_java.library.server_base.binary_transfer.upload.UploadService;
import sila_java.library.server_base.standard_features.v1.AuthorizationController;
import sila_java.library.sila_base.EmptyClass;

public class CloudTestServer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(CloudTestServer.class);
    private final CloudierSiLAService cloudierSiLAService;
    private final CloudierConnectionConfigurationService cloudierConnectionConfigurationService;
    private final ObservableCommand observableCommand = new ObservableCommand();
    private final ObservableProperty observableProperty = new ObservableProperty();
    private final UnobservableCommand unobservableCommand;
    private final sila_java.library.server_base.standard_features.v1.ParameterConstraintsProvider ParameterConstraintsProvider = new sila_java.library.server_base.standard_features.v1.ParameterConstraintsProvider(AuthorizationController.DEFAULT_AUTHORIZE);
    private final ParameterConstraintsProvider parameterConstraintsProvider = new ParameterConstraintsProvider(this.ParameterConstraintsProvider);
    private final BinaryDatabase binaryDatabase;
    private CloudClientEndpointGrpc.CloudClientEndpointStub clientEndpoint;
    private CloudierServerEndpoint cloudServerEndpointService;
    private ManagedChannel channel;

    public static void main(String[] args) throws Exception {
        UUID serverUUID = UUID.randomUUID();
        H2BinaryDatabase binaryDatabase = new H2BinaryDatabase(serverUUID);
        CloudTestServer cloudTestServer = new CloudTestServer(serverUUID, (BinaryDatabase)binaryDatabase);
        log.info("To stop the server press CTRL + C.");
        Utils.blockUntilShutdown(() -> CloudTestServer.lambda$main$0((BinaryDatabase)binaryDatabase, cloudTestServer));
    }

    public CloudTestServer(UUID serverUUID, BinaryDatabase binaryDatabase) throws IOException {
        this.binaryDatabase = binaryDatabase;
        this.unobservableCommand = new UnobservableCommand();
        ImmutableMap immutableMap = ImmutableMap.builder().put((Object)"SiLAService", (Object)FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/core/SiLAService-v1_0.sila.xml")))).put((Object)"ConnectionConfigurationService", (Object)FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/core/ConnectionConfigurationService-v1_0.sila.xml")))).put((Object)"ParameterConstraintsProvider", (Object)FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/core/commands/ParameterConstraintsProvider-v1_0.sila.xml")))).put((Object)"ObservablePropertyTest", (Object)FileUtils.getFileContent((InputStream)Objects.requireNonNull(TestServer.class.getResourceAsStream("/features/ObservablePropertyTest.sila.xml")))).put((Object)"UnobservableCommandTest", (Object)FileUtils.getFileContent((InputStream)Objects.requireNonNull(TestServer.class.getResourceAsStream("/features/UnobservableCommandTest.sila.xml")))).put((Object)"ObservableCommandTest", (Object)FileUtils.getFileContent((InputStream)Objects.requireNonNull(TestServer.class.getResourceAsStream("/features/ObservableCommandTest.sila.xml")))).put((Object)"ParameterConstraintsProviderTest", (Object)FileUtils.getFileContent((InputStream)Objects.requireNonNull(TestServer.class.getResourceAsStream("/features/ParameterConstraintsProviderTest.sila.xml")))).put((Object)"UnobservablePropertyTest", (Object)FileUtils.getFileContent((InputStream)Objects.requireNonNull(TestServer.class.getResourceAsStream("/features/UnobservablePropertyTest.sila.xml")))).build();
        this.cloudierSiLAService = new CloudierSiLAService("Cloud Test Server", TestServer.SERVER_INFORMATION.getType(), serverUUID.toString(), TestServer.SERVER_INFORMATION.getVersion(), TestServer.SERVER_INFORMATION.getDescription(), TestServer.SERVER_INFORMATION.getVendorURL(), (Map)immutableMap);
        this.cloudierConnectionConfigurationService = new CloudierConnectionConfigurationService(false, connectionMode -> {});
        this.startServerInitiatedConnection();
    }

    private void startServerInitiatedConnection() {
        this.channel = ChannelFactory.getTLSEncryptedChannel((String)"127.0.0.1", (int)50051);
        this.clientEndpoint = CloudClientEndpointGrpc.newStub((Channel)this.channel);
        HashMap<String, MessageCaseHandler> callForwarderMap = new HashMap<String, MessageCaseHandler>(){
            {
                this.put("ch.unitelabs/test/ObservableCommandTest/v1/Command/RestartDevice", new MessageCaseHandler().withObservableCommand(ObservableCommandTestOuterClass.RestartDevice_Parameters.parser(), CloudTestServer.this.observableCommand::restartDevice).withExecInfo(SiLAFramework.CommandExecutionUUID.parser(), CloudTestServer.this.observableCommand::restartDeviceInfo).withIntermediate(SiLAFramework.CommandExecutionUUID.parser(), CloudTestServer.this.observableCommand::restartDeviceIntermediate).withResult(SiLAFramework.CommandExecutionUUID.parser(), CloudTestServer.this.observableCommand::restartDeviceResult));
                this.put("ch.unitelabs/test/ObservablePropertyTest/v1/Property/ListString", new MessageCaseHandler().withObservableProperty(ObservablePropertyTestOuterClass.Subscribe_ListString_Parameters.parser(), CloudTestServer.this.observableProperty::subscribeListString));
                this.put("ch.unitelabs/test/ObservablePropertyTest/v1/Property/SingletonListString", new MessageCaseHandler().withObservableProperty(ObservablePropertyTestOuterClass.Subscribe_SingletonListString_Parameters.parser(), CloudTestServer.this.observableProperty::subscribeSingletonListString));
                this.put("ch.unitelabs/test/ParameterConstraintsProviderTest/v1/Command/GoToPos", new MessageCaseHandler().withUnobservableCommand(ParameterConstraintsProviderTestOuterClass.GoToPos_Parameters.parser(), CloudTestServer.this.parameterConstraintsProvider::goToPos));
                this.put("ch.unitelabs/test/ParameterConstraintsProviderTest/v1/Command/AddPosition", new MessageCaseHandler().withUnobservableCommand(ParameterConstraintsProviderTestOuterClass.AddPosition_Parameters.parser(), CloudTestServer.this.parameterConstraintsProvider::addPosition));
                this.put("ch.unitelabs/test/ParameterConstraintsProviderTest/v1/Command/RemovePosition", new MessageCaseHandler().withUnobservableCommand(ParameterConstraintsProviderTestOuterClass.RemovePosition_Parameters.parser(), CloudTestServer.this.parameterConstraintsProvider::removePosition));
                this.put("ch.unitelabs/test/ParameterConstraintsProviderTest/v1/Property/Positions", new MessageCaseHandler().withUnobservableProperty(ParameterConstraintsProviderTestOuterClass.Get_Positions_Parameters.parser(), CloudTestServer.this.parameterConstraintsProvider::getPositions));
                this.put("ch.unitelabs/test/UnobservableCommandTest/v1/Command/MakeCoffee", new MessageCaseHandler().withUnobservableCommand(UnobservableCommandTestOuterClass.MakeCoffee_Parameters.parser(), CloudTestServer.this.unobservableCommand::makeCoffee));
                this.put("ch.unitelabs/test/UnobservableCommandTest/v1/Command/Sleep", new MessageCaseHandler().withUnobservableCommand(UnobservableCommandTestOuterClass.Sleep_Parameters.parser(), CloudTestServer.this.unobservableCommand::sleep));
                ParameterConstraintsProviderGrpc.ParameterConstraintsProviderImplBase s = (ParameterConstraintsProviderGrpc.ParameterConstraintsProviderImplBase)CloudTestServer.this.ParameterConstraintsProvider.getService();
                this.put("org.silastandard/core.commands/ParameterConstraintsProvider/v1/Property/ParametersConstraints", new MessageCaseHandler().withObservableProperty(ParameterConstraintsProviderOuterClass.Subscribe_ParametersConstraints_Parameters.parser(), (arg_0, arg_1) -> ((ParameterConstraintsProviderGrpc.ParameterConstraintsProviderImplBase)s).subscribeParametersConstraints(arg_0, arg_1)));
            }
        };
        UploadService uploadService = new UploadService(this.binaryDatabase, this.cloudierSiLAService.getFeatures().values(), AuthorizationController.DEFAULT_AUTHORIZE);
        DownloadService downloadService = new DownloadService(this.binaryDatabase, AuthorizationController.DEFAULT_AUTHORIZE);
        this.cloudServerEndpointService = new CloudierServerEndpoint(this.cloudierSiLAService, this.cloudierConnectionConfigurationService, this.clientEndpoint, (Map)callForwarderMap, (BinaryUploadGrpc.BinaryUploadImplBase)uploadService, (BinaryDownloadGrpc.BinaryDownloadImplBase)downloadService);
    }

    @Override
    public void close() {
        this.observableCommand.close();
        this.channel.shutdown();
    }

    private static /* synthetic */ void lambda$main$0(BinaryDatabase binaryDatabase, CloudTestServer cloudTestServer) {
        try {
            binaryDatabase.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        cloudTestServer.close();
    }
}

