/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.test_server;

import com.google.common.base.Verify;
import io.grpc.BindableService;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.ch.unitelabs.test.observablecommandtest.v1.ObservableCommandTestOuterClass;
import sila2.ch.unitelabs.test.observablepropertytest.v1.ObservablePropertyTestOuterClass;
import sila2.ch.unitelabs.test.parameterconstraintsprovidertest.v1.ParameterConstraintsProviderTestOuterClass;
import sila2.ch.unitelabs.test.unobservablecommandtest.v1.UnobservableCommandTestOuterClass;
import sila2.org.silastandard.CloudClientEndpointGrpc;
import sila2.org.silastandard.SiLAFramework;
import sila2.org.silastandard.core.commands.parameterconstraintsprovider.v1.ParameterConstraintsProviderGrpc;
import sila2.org.silastandard.core.commands.parameterconstraintsprovider.v1.ParameterConstraintsProviderOuterClass;
import sila_java.examples.test_server.impl.ComplexDatatypeTest;
import sila_java.examples.test_server.impl.ObservableCommand;
import sila_java.examples.test_server.impl.ObservableProperty;
import sila_java.examples.test_server.impl.ParameterConstraintsProvider;
import sila_java.examples.test_server.impl.UnobservableCommand;
import sila_java.examples.test_server.sila_base.impl.BasicDatatypeTest;
import sila_java.examples.test_server.sila_base.impl.ListDatatypeTest;
import sila_java.examples.test_server.sila_base.impl.ObservableCommandTest;
import sila_java.examples.test_server.sila_base.impl.ObservablePropertyTest;
import sila_java.examples.test_server.sila_base.impl.StructureDatatypeTest;
import sila_java.examples.test_server.sila_base.impl.UnobservablePropertyTest;
import sila_java.library.cloudier.server.CloudierConnectionConfigurationService;
import sila_java.library.cloudier.server.CloudierServerEndpoint;
import sila_java.library.cloudier.server.CloudierSiLAService;
import sila_java.library.cloudier.server.MessageCaseHandler;
import sila_java.library.core.sila.clients.ChannelFactory;
import sila_java.library.core.utils.FileUtils;
import sila_java.library.core.utils.Utils;
import sila_java.library.server_base.SiLAServer;
import sila_java.library.server_base.binary_transfer.database.BinaryDatabase;
import sila_java.library.server_base.binary_transfer.database.impl.H2BinaryDatabase;
import sila_java.library.server_base.config.IServerConfigWrapper;
import sila_java.library.server_base.identification.ServerInformation;
import sila_java.library.server_base.standard_features.FeatureImplementation;
import sila_java.library.server_base.standard_features.v1.AuthorizationController;
import sila_java.library.server_base.utils.ArgumentHelper;
import sila_java.library.sila_base.EmptyClass;

public class TestServer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(TestServer.class);
    static final String SERVER_TYPE = "TestServer";
    public static final ServerInformation SERVER_INFORMATION = new ServerInformation("TestServer", "Server for test purposes", "https://www.sila-standard.org", "0.0");
    private final ObservableCommand observableCommandService = new ObservableCommand();
    private final ObservableProperty observablePropertyService = new ObservableProperty();
    private final ParameterConstraintsProvider parameterConstraintsProviderService;
    private final sila_java.library.server_base.standard_features.v1.ParameterConstraintsProvider parameterConstraintsProvider;
    private final CloudierConnectionConfigurationService connectionConfigurationService = new CloudierConnectionConfigurationService(false, this::onServerConnectionModeChange);
    private final SiLAServer.Builder builder;
    private final BinaryDatabase binaryDatabase;
    private final IServerConfigWrapper configuration;
    private final ComplexDatatypeTest complexDataTypeTest;
    private final BasicDatatypeTest basicDatatypeTest;
    private final ListDatatypeTest listDatatypeTest;
    private final StructureDatatypeTest structureDatatypeTest;
    private final ObservableCommandTest observableCommandTestService;
    private final ObservablePropertyTest observablePropertyTestService;
    private final UnobservablePropertyTest unobservablePropertyTestService;
    private final UnobservableCommand unobservableCommand;
    private SiLAServer clientInitiatedServer;
    private CloudierSiLAService cloudierSiLAService;
    private CloudClientEndpointGrpc.CloudClientEndpointStub clientEndpoint;
    private CloudierServerEndpoint cloudServerEndpointService;
    private ManagedChannel channel;
    private Thread serverInitiatedServerThread;

    private HashMap<String, MessageCaseHandler> getCallForwarderMap() {
        return new HashMap<String, MessageCaseHandler>(){
            {
                this.put("ch.unitelabs/test/ObservableCommandTest/v1/Command/RestartDevice", new MessageCaseHandler().withObservableCommand(ObservableCommandTestOuterClass.RestartDevice_Parameters.parser(), TestServer.this.observableCommandService::restartDevice).withExecInfo(SiLAFramework.CommandExecutionUUID.parser(), TestServer.this.observableCommandService::restartDeviceInfo).withIntermediate(SiLAFramework.CommandExecutionUUID.parser(), TestServer.this.observableCommandService::restartDeviceIntermediate).withResult(SiLAFramework.CommandExecutionUUID.parser(), TestServer.this.observableCommandService::restartDeviceResult));
                this.put("ch.unitelabs/test/ObservablePropertyTest/v1/Property/ListString", new MessageCaseHandler().withObservableProperty(ObservablePropertyTestOuterClass.Subscribe_ListString_Parameters.parser(), TestServer.this.observablePropertyService::subscribeListString));
                this.put("ch.unitelabs/test/ObservablePropertyTest/v1/Property/SingletonListString", new MessageCaseHandler().withObservableProperty(ObservablePropertyTestOuterClass.Subscribe_SingletonListString_Parameters.parser(), TestServer.this.observablePropertyService::subscribeSingletonListString));
                this.put("ch.unitelabs/test/ParameterConstraintsProviderTest/v1/Command/GoToPos", new MessageCaseHandler().withUnobservableCommand(ParameterConstraintsProviderTestOuterClass.GoToPos_Parameters.parser(), TestServer.this.parameterConstraintsProviderService::goToPos));
                this.put("ch.unitelabs/test/ParameterConstraintsProviderTest/v1/Command/AddPosition", new MessageCaseHandler().withUnobservableCommand(ParameterConstraintsProviderTestOuterClass.AddPosition_Parameters.parser(), TestServer.this.parameterConstraintsProviderService::addPosition));
                this.put("ch.unitelabs/test/ParameterConstraintsProviderTest/v1/Command/RemovePosition", new MessageCaseHandler().withUnobservableCommand(ParameterConstraintsProviderTestOuterClass.RemovePosition_Parameters.parser(), TestServer.this.parameterConstraintsProviderService::removePosition));
                this.put("ch.unitelabs/test/ParameterConstraintsProviderTest/v1/Property/Positions", new MessageCaseHandler().withUnobservableProperty(ParameterConstraintsProviderTestOuterClass.Get_Positions_Parameters.parser(), TestServer.this.parameterConstraintsProviderService::getPositions));
                this.put("ch.unitelabs/test/UnobservableCommandTest/v1/Command/MakeCoffee", new MessageCaseHandler().withUnobservableCommand(UnobservableCommandTestOuterClass.MakeCoffee_Parameters.parser(), TestServer.this.unobservableCommand::makeCoffee));
                this.put("ch.unitelabs/test/UnobservableCommandTest/v1/Command/Sleep", new MessageCaseHandler().withUnobservableCommand(UnobservableCommandTestOuterClass.Sleep_Parameters.parser(), TestServer.this.unobservableCommand::sleep));
                ParameterConstraintsProviderGrpc.ParameterConstraintsProviderImplBase s = (ParameterConstraintsProviderGrpc.ParameterConstraintsProviderImplBase)TestServer.this.parameterConstraintsProvider.getService();
                this.put("org.silastandard/core.commands/ParameterConstraintsProvider/v1/Property/ParametersConstraints", new MessageCaseHandler().withObservableProperty(ParameterConstraintsProviderOuterClass.Subscribe_ParametersConstraints_Parameters.parser(), (arg_0, arg_1) -> ((ParameterConstraintsProviderGrpc.ParameterConstraintsProviderImplBase)s).subscribeParametersConstraints(arg_0, arg_1)));
            }
        };
    }

    private static String getCoreFeatureContent(@NonNull String coreFeaturePath) {
        if (coreFeaturePath == null) {
            throw new NullPointerException("coreFeaturePath is marked non-null but is null");
        }
        return FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/core/" + coreFeaturePath)));
    }

    public TestServer(@NonNull ArgumentHelper argumentHelper) {
        if (argumentHelper == null) {
            throw new NullPointerException("argumentHelper is marked non-null but is null");
        }
        try {
            this.builder = SiLAServer.Builder.newBuilder((ServerInformation)SERVER_INFORMATION);
            this.builder.withPersistentConfig(argumentHelper.getConfigFile().isPresent());
            argumentHelper.getConfigFile().ifPresent(arg_0 -> ((SiLAServer.Builder)this.builder).withPersistentConfigFile(arg_0));
            this.builder.withPersistentTLS(argumentHelper.getPrivateKeyFile(), argumentHelper.getCertificateFile(), argumentHelper.getCertificatePassword());
            argumentHelper.getPort().ifPresent(arg_0 -> ((SiLAServer.Builder)this.builder).withPort(arg_0));
            argumentHelper.getInterface().ifPresent(arg_0 -> ((SiLAServer.Builder)this.builder).withNetworkInterface(arg_0));
            if (argumentHelper.useUnsafeCommunication()) {
                this.builder.withUnsafeCommunication(true);
            }
            this.builder.withMetadataExtractingInterceptor();
            this.builder.withBinaryTransferSupport(true);
            this.configuration = this.builder.getNewServerConfigurationWrapper();
            this.builder.withCustomConfigWrapperProvider((configPath, serverConfiguration) -> this.configuration);
            this.binaryDatabase = new H2BinaryDatabase(this.configuration.getCacheConfig().getUuid());
            this.builder.withCustomBinaryDatabaseProvider(uuid -> this.binaryDatabase);
            this.complexDataTypeTest = new ComplexDatatypeTest(this.binaryDatabase);
            this.basicDatatypeTest = new BasicDatatypeTest();
            this.listDatatypeTest = new ListDatatypeTest();
            this.structureDatatypeTest = new StructureDatatypeTest();
            this.unobservablePropertyTestService = new UnobservablePropertyTest();
            this.observableCommandTestService = new ObservableCommandTest();
            this.observablePropertyTestService = new ObservablePropertyTest();
            this.unobservableCommand = new UnobservableCommand();
            AuthorizationController.Authorize authorize = this.builder.getAuthorize() == null ? AuthorizationController.DEFAULT_AUTHORIZE : this.builder.getAuthorize();
            this.parameterConstraintsProvider = new sila_java.library.server_base.standard_features.v1.ParameterConstraintsProvider(authorize);
            this.parameterConstraintsProviderService = new ParameterConstraintsProvider(this.parameterConstraintsProvider);
            this.builder.addFeature(FileUtils.getFileContent((InputStream)EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/test/BasicDataTypesTest-v1_0.sila.xml")), (BindableService)this.basicDatatypeTest).addFeature(FileUtils.getFileContent((InputStream)EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/test/ListDataTypeTest-v1_0.sila.xml")), (BindableService)this.listDatatypeTest).addFeature(FileUtils.getFileContent((InputStream)EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/test/StructureDataTypeTest-v1_0.sila.xml")), (BindableService)this.structureDatatypeTest).addFeature(FileUtils.getFileContent((InputStream)EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/test/ObservableCommandTest-v1_0.sila.xml")), (BindableService)this.observableCommandTestService).addFeature(FileUtils.getFileContent((InputStream)EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/test/ObservablePropertyTest-v1_0.sila.xml")), (BindableService)this.observablePropertyTestService).addFeature(FileUtils.getFileContent((InputStream)EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/test/UnobservablePropertyTest-v1_0.sila.xml")), (BindableService)this.unobservablePropertyTestService).addFeature(FileUtils.getResourceContent((String)"features/ComplexDataTypeTest.sila.xml"), (BindableService)this.complexDataTypeTest).addFeature(FileUtils.getResourceContent((String)"features/ObservablePropertyTest.sila.xml"), (BindableService)this.observablePropertyService).addFeature(FileUtils.getResourceContent((String)"features/UnobservableCommandTest.sila.xml"), (BindableService)this.unobservableCommand).addFeature(FileUtils.getResourceContent((String)"features/ObservableCommandTest.sila.xml"), (BindableService)this.observableCommandService).addFeature(FileUtils.getResourceContent((String)"features/ParameterConstraintsProviderTest.sila.xml"), (BindableService)this.parameterConstraintsProviderService).addFeature(TestServer.getCoreFeatureContent("ConnectionConfigurationService-v1_0.sila.xml"), (BindableService)this.connectionConfigurationService).addFeature((FeatureImplementation)this.parameterConstraintsProvider);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void startClientInitiatedServer() throws IOException {
        log.info("Starting server in client initiated mode");
        this.clientInitiatedServer = this.builder.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onServerConnectionModeChange(boolean serverInitiatedConnectionEnabled) {
        log.info("Server connection mode switching to {}", (Object)(serverInitiatedConnectionEnabled ? "Server Initiated" : "Client Initiated"));
        if (serverInitiatedConnectionEnabled) {
            try {
                this.clientInitiatedServer.close();
            }
            catch (Exception e) {
                log.warn("Exception occurred while closing client initiated server");
            }
            finally {
                this.clientInitiatedServer = null;
            }
        } else {
            try {
                this.channel.shutdown();
                try {
                    this.channel.awaitTermination(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    this.channel.shutdownNow();
                }
                Verify.verify((boolean)this.channel.isShutdown());
                this.serverInitiatedServerThread.interrupt();
                for (int i = 0; this.serverInitiatedServerThread.isAlive() && i < 50; ++i) {
                    Thread.sleep(100L);
                }
                if (this.serverInitiatedServerThread.isAlive()) {
                    this.serverInitiatedServerThread.stop();
                }
            }
            catch (Exception e) {
                log.warn("Exception occurred while closing server initiated server!");
            }
            finally {
                this.channel = null;
                this.cloudServerEndpointService = null;
                this.clientEndpoint = null;
                this.cloudierSiLAService = null;
                this.serverInitiatedServerThread = null;
            }
        }
        if (serverInitiatedConnectionEnabled) {
            this.startServerInitiatedConnection(this.configuration.getCacheConfig().getUuid());
        } else {
            try {
                this.startClientInitiatedServer();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        log.info("Server connection mode switched to {}", (Object)(serverInitiatedConnectionEnabled ? "Server Initiated" : "Client Initiated"));
    }

    private void startServerInitiatedConnection(@NonNull UUID serverUUID) {
        if (serverUUID == null) {
            throw new NullPointerException("serverUUID is marked non-null but is null");
        }
        this.serverInitiatedServerThread = new Thread(() -> {
            this.cloudierSiLAService = new CloudierSiLAService(this.configuration.getCacheConfig().getName(), SERVER_INFORMATION.getType(), serverUUID.toString(), SERVER_INFORMATION.getVersion(), SERVER_INFORMATION.getDescription(), SERVER_INFORMATION.getVendorURL(), this.builder.getFeatureDefinitions());
            this.channel = ChannelFactory.getTLSEncryptedChannel((String)"127.0.0.1", (int)50051);
            this.clientEndpoint = CloudClientEndpointGrpc.newStub((Channel)this.channel);
            this.cloudServerEndpointService = new CloudierServerEndpoint(this.cloudierSiLAService, this.connectionConfigurationService, this.clientEndpoint, this.getCallForwarderMap(), null, null);
        });
        this.serverInitiatedServerThread.start();
    }

    @Override
    public void close() {
        if (this.clientInitiatedServer != null) {
            this.clientInitiatedServer.close();
        }
        if (this.channel != null) {
            this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
        this.observableCommandService.close();
        this.binaryDatabase.close();
    }

    public static void main(String[] args) {
        ArgumentHelper argumentHelper = new ArgumentHelper(args, SERVER_TYPE);
        TestServer server = new TestServer(argumentHelper);
        server.startClientInitiatedServer();
        log.info("To stop the server press CTRL + C.");
        Utils.blockUntilShutdown(server::close);
        log.info("Server closed.");
    }
}

