/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.test_server.impl;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLAFramework;
import sila2.org.silastandard.test.complexdatatypetest.v1.ComplexDataTypeTestGrpc;
import sila2.org.silastandard.test.complexdatatypetest.v1.ComplexDataTypeTestOuterClass;
import sila_java.examples.test_server.utils.ByteArrayProcessedInputStream;
import sila_java.examples.test_server.utils.Bytes;
import sila_java.library.core.models.BasicType;
import sila_java.library.core.models.DataTypeType;
import sila_java.library.core.models.SiLAElement;
import sila_java.library.core.models.StructureType;
import sila_java.library.core.sila.errors.SiLAErrors;
import sila_java.library.core.sila.mapping.feature.MalformedSiLAFeature;
import sila_java.library.core.sila.mapping.grpc.ProtoMapper;
import sila_java.library.core.sila.types.SiLAAny;
import sila_java.library.core.sila.types.SiLABinary;
import sila_java.library.core.sila.types.SiLABoolean;
import sila_java.library.core.sila.types.SiLAInteger;
import sila_java.library.core.sila.types.SiLAReal;
import sila_java.library.core.sila.types.SiLAString;
import sila_java.library.server_base.binary_transfer.Binary;
import sila_java.library.server_base.binary_transfer.database.BinaryDatabase;
import sila_java.library.server_base.binary_transfer.database.BinaryDatabaseException;

public class ComplexDatatypeTest
extends ComplexDataTypeTestGrpc.ComplexDataTypeTestImplBase {
    private static final Logger log = LoggerFactory.getLogger(ComplexDatatypeTest.class);
    private static final String FULLY_QUALIFIED_FEATURE_IDENTIFIER = "org.silastandard/test/ComplexDatatypeTest/v1";
    public static final ComplexDataTypeTestOuterClass.WhyMakeItSimpleWhenYouCanMakeItComplicated_Responses COMPLICATED_RESPONSES = ComplexDataTypeTestOuterClass.WhyMakeItSimpleWhenYouCanMakeItComplicated_Responses.newBuilder().setFirstResponse(SiLAString.from((String)"Dead")).setSecondResponse(SiLAString.from((String)"Alive")).build();
    public static final ComplexDataTypeTestOuterClass.ThreeDimensionalStruct_Responses THREE_DIMENSIONAL_STRUCT_RESPONSES = ComplexDataTypeTestOuterClass.ThreeDimensionalStruct_Responses.newBuilder().setThreeDimensionalListResult(ComplexDataTypeTestOuterClass.DataType_ThreeDimensionalString.newBuilder().addThreeDimensionalString(ComplexDataTypeTestOuterClass.DataType_TwoDimensionalString.newBuilder().addTwoDimensionalString(ComplexDataTypeTestOuterClass.DataType_OneDimensionalString.newBuilder().addOneDimensionalString(SiLAString.from((String)"000")).build()).build())).build();
    public static final ComplexDataTypeTestOuterClass.ThreeDimensionalList_Responses THREE_DIMENSIONAL_LIST_RESPONSES = ComplexDataTypeTestOuterClass.ThreeDimensionalList_Responses.newBuilder().setThreeDimensionalStructResult(ComplexDataTypeTestOuterClass.ThreeDimensionalList_Responses.ThreeDimensionalStructResult_Struct.newBuilder().setFirstDimension(ComplexDataTypeTestOuterClass.ThreeDimensionalList_Responses.ThreeDimensionalStructResult_Struct.FirstDimension_Struct.newBuilder().setSecondDimension(ComplexDataTypeTestOuterClass.ThreeDimensionalList_Responses.ThreeDimensionalStructResult_Struct.FirstDimension_Struct.SecondDimension_Struct.newBuilder().setThirdDimension(SiLAString.from((String)"111")).build()).build()).build()).build();
    public static final int NB_ELEMENT_HUGE_LIST = 1000;
    public static final String[] STRING_ARRAY = new String[]{"Switzerland", "Germany", "France", "Italy", "Finland", "Russia", "Latvia", "Lithuania", "Poland", "Portugal", "Follow", "the White", "Rabbit"};
    public static final List<SiLAFramework.String> HUGE_LIST = new ArrayList<SiLAFramework.String>(1000);
    public static final ComplexDataTypeTestOuterClass.Get_ListString_Responses LIST_STRING_RESPONSE;
    public static final ComplexDataTypeTestOuterClass.Get_ListStructPairString_Responses LIST_STRUCT_PAIR_STRING_RESPONSE;
    public static final ComplexDataTypeTestOuterClass.Get_StructPairString_Responses STRUCT_PAIR_STRING_RESPONSE;
    public static final ComplexDataTypeTestOuterClass.Get_DataType_Responses DATA_TYPE_RESPONSE;
    private final BinaryDatabase binaryDatabase;

    public ComplexDatatypeTest(@NonNull BinaryDatabase binaryDatabase) {
        if (binaryDatabase == null) {
            throw new NullPointerException("binaryDatabase is marked non-null but is null");
        }
        this.binaryDatabase = binaryDatabase;
    }

    @Override
    public void listProvider(ComplexDataTypeTestOuterClass.ListProvider_Parameters request, StreamObserver<ComplexDataTypeTestOuterClass.ListProvider_Responses> responseObserver) {
        long listLength = request.getListLength().getValue();
        long elementLength = request.getElementLength().getValue();
        ArrayList<SiLAFramework.String> list = new ArrayList<SiLAFramework.String>((int)listLength);
        int i = 0;
        while ((long)i < listLength) {
            list.add(i, SiLAString.from((String)RandomStringUtils.randomAlphanumeric((int)((int)elementLength))));
            ++i;
        }
        responseObserver.onNext((Object)ComplexDataTypeTestOuterClass.ListProvider_Responses.newBuilder().addAllList(list).build());
        responseObserver.onCompleted();
    }

    @Override
    public void threeDimensionalStruct(ComplexDataTypeTestOuterClass.ThreeDimensionalStruct_Parameters request, StreamObserver<ComplexDataTypeTestOuterClass.ThreeDimensionalStruct_Responses> responseObserver) {
        responseObserver.onNext((Object)THREE_DIMENSIONAL_STRUCT_RESPONSES);
        responseObserver.onCompleted();
    }

    @Override
    public void threeDimensionalList(ComplexDataTypeTestOuterClass.ThreeDimensionalList_Parameters request, StreamObserver<ComplexDataTypeTestOuterClass.ThreeDimensionalList_Responses> responseObserver) {
        responseObserver.onNext((Object)THREE_DIMENSIONAL_LIST_RESPONSES);
        responseObserver.onCompleted();
    }

    @Override
    public void whyMakeItSimpleWhenYouCanMakeItComplicated(ComplexDataTypeTestOuterClass.WhyMakeItSimpleWhenYouCanMakeItComplicated_Parameters request, StreamObserver<ComplexDataTypeTestOuterClass.WhyMakeItSimpleWhenYouCanMakeItComplicated_Responses> responseObserver) {
        responseObserver.onNext((Object)COMPLICATED_RESPONSES);
        responseObserver.onCompleted();
    }

    @Override
    public void xOREncipher(ComplexDataTypeTestOuterClass.XOREncipher_Parameters request, StreamObserver<ComplexDataTypeTestOuterClass.XOREncipher_Responses> responseObserver) {
        byte key = (byte)request.getCipherKey().getValue();
        if (!request.getData().getBinaryTransferUUID().isEmpty()) {
            try {
                UUID uuid = this.XOREncipherSiLABinary(UUID.fromString(request.getData().getBinaryTransferUUID()), key);
                responseObserver.onNext((Object)ComplexDataTypeTestOuterClass.XOREncipher_Responses.newBuilder().setData(SiLABinary.fromBinaryTransferUUID((UUID)uuid)).build());
            }
            catch (SQLException | BinaryDatabaseException e) {
                log.error("Error happened while applying XOR Cipher on SiLA Binary {}", (Object)request.getData().getBinaryTransferUUID(), (Object)e);
                responseObserver.onError(e);
                return;
            }
        } else {
            byte[] data = request.getData().getValue().toByteArray();
            Bytes.XOREncipherBytes(data, key, 0, data.length);
            responseObserver.onNext((Object)ComplexDataTypeTestOuterClass.XOREncipher_Responses.newBuilder().setData(SiLABinary.fromBytes((byte[])data)).build());
        }
        responseObserver.onCompleted();
    }

    @Override
    public void valueForTypeProvider(ComplexDataTypeTestOuterClass.ValueForTypeProvider_Parameters request, StreamObserver<ComplexDataTypeTestOuterClass.ValueForTypeProvider_Responses> responseObserver) {
        SiLAFramework.Any any;
        DynamicMessage anonymousStructureMessage;
        DataTypeType integerType = new DataTypeType();
        integerType.setBasic(BasicType.INTEGER);
        DataTypeType anonymousStructureType = new DataTypeType();
        StructureType structureType = new StructureType();
        SiLAElement element = new SiLAElement();
        element.setDataType(integerType);
        element.setDescription("X");
        element.setDisplayName("X");
        element.setIdentifier("X");
        structureType.getElement().add(element);
        anonymousStructureType.setStructure(structureType);
        try {
            Descriptors.Descriptor anonymousStructureDescriptor = ProtoMapper.dataTypeToDescriptor((DataTypeType)anonymousStructureType);
            anonymousStructureMessage = DynamicMessage.newBuilder((Descriptors.Descriptor)anonymousStructureDescriptor).setField(anonymousStructureDescriptor.findFieldByName("X"), (Object)SiLAInteger.from((long)101L)).build();
        }
        catch (MalformedSiLAFeature e) {
            throw new RuntimeException(e);
        }
        switch (request.getType().getValue()) {
            case "Integer": {
                any = SiLAAny.from((DataTypeType)integerType, (Message)SiLAInteger.from((long)1337L));
                break;
            }
            case "String": {
                any = SiLAAny.from((String)"<DataType><Basic>String</Basic></DataType>", (Message)SiLAString.from((String)"test"));
                break;
            }
            case "ConstrainedReal": {
                any = SiLAAny.from((String)"<DataType><Constrained><DataType><Basic>Real</Basic></DataType><Constraints><MinimalInclusive>4.2</MinimalInclusive><MaximalInclusive>133.7</MaximalInclusive></Constraints></Constrained></DataType>", (Message)SiLAReal.from((double)7.7));
                break;
            }
            case "AnonymousStructure": {
                any = SiLAAny.from((DataTypeType)anonymousStructureType, (Message)anonymousStructureMessage);
                break;
            }
            case "AnonymousList": {
                any = SiLAAny.from((String)"<DataType><List><DataType><Basic>Any</Basic></DataType></List></DataType>", (Message)ComplexDataTypeTestOuterClass.DataType_AnonymousList.newBuilder().addAnonymousList(SiLAAny.from((DataTypeType)integerType, (Message)SiLAInteger.from((long)777L))).addAnonymousList(SiLAAny.from((String)"<DataType><Basic>String</Basic></DataType>", (Message)SiLAString.from((String)"SiLA"))).build());
                break;
            }
            default: {
                responseObserver.onError((Throwable)SiLAErrors.generateUndefinedExecutionError((String)("Unsupported type: " + request.getType().getValue())));
                return;
            }
        }
        responseObserver.onNext((Object)ComplexDataTypeTestOuterClass.ValueForTypeProvider_Responses.newBuilder().setAny(any).build());
        responseObserver.onCompleted();
    }

    @Override
    public void getHugeList(ComplexDataTypeTestOuterClass.Get_HugeList_Parameters request, StreamObserver<ComplexDataTypeTestOuterClass.Get_HugeList_Responses> responseObserver) {
        responseObserver.onNext((Object)ComplexDataTypeTestOuterClass.Get_HugeList_Responses.newBuilder().addAllHugeList(HUGE_LIST).build());
        responseObserver.onCompleted();
    }

    @Override
    public void getBoolean(ComplexDataTypeTestOuterClass.Get_Boolean_Parameters request, StreamObserver<ComplexDataTypeTestOuterClass.Get_Boolean_Responses> responseObserver) {
        responseObserver.onNext((Object)ComplexDataTypeTestOuterClass.Get_Boolean_Responses.newBuilder().setBoolean(SiLABoolean.from((Math.random() < 0.5 ? 1 : 0) != 0)).build());
        responseObserver.onCompleted();
    }

    @Override
    public void getListString(ComplexDataTypeTestOuterClass.Get_ListString_Parameters request, StreamObserver<ComplexDataTypeTestOuterClass.Get_ListString_Responses> responseObserver) {
        responseObserver.onNext((Object)LIST_STRING_RESPONSE);
        responseObserver.onCompleted();
    }

    @Override
    public void getRandomChangingListString(ComplexDataTypeTestOuterClass.Get_RandomChangingListString_Parameters request, StreamObserver<ComplexDataTypeTestOuterClass.Get_RandomChangingListString_Responses> responseObserver) {
        ComplexDataTypeTestOuterClass.Get_RandomChangingListString_Responses.Builder newListRes = ComplexDataTypeTestOuterClass.Get_RandomChangingListString_Responses.newBuilder();
        ComplexDatatypeTest.getNewList().forEach(item -> newListRes.addRandomChangingListString(SiLAString.from((String)item)));
        responseObserver.onNext((Object)newListRes.build());
        responseObserver.onCompleted();
    }

    @Override
    public void getListStructPairString(ComplexDataTypeTestOuterClass.Get_ListStructPairString_Parameters request, StreamObserver<ComplexDataTypeTestOuterClass.Get_ListStructPairString_Responses> responseObserver) {
        responseObserver.onNext((Object)LIST_STRUCT_PAIR_STRING_RESPONSE);
        responseObserver.onCompleted();
    }

    @Override
    public void getStructPairString(ComplexDataTypeTestOuterClass.Get_StructPairString_Parameters request, StreamObserver<ComplexDataTypeTestOuterClass.Get_StructPairString_Responses> responseObserver) {
        responseObserver.onNext((Object)STRUCT_PAIR_STRING_RESPONSE);
        responseObserver.onCompleted();
    }

    @Override
    public void getDataType(ComplexDataTypeTestOuterClass.Get_DataType_Parameters request, StreamObserver<ComplexDataTypeTestOuterClass.Get_DataType_Responses> responseObserver) {
        responseObserver.onNext((Object)DATA_TYPE_RESPONSE);
        responseObserver.onCompleted();
    }

    @Override
    public void getThrowException(ComplexDataTypeTestOuterClass.Get_ThrowException_Parameters request, StreamObserver<ComplexDataTypeTestOuterClass.Get_ThrowException_Responses> responseObserver) {
        responseObserver.onError((Throwable)SiLAErrors.generateDefinedExecutionError((String)"org.silastandard/test/ComplexDatatypeTest/v1/DefinedExecutionError/TestException", (String)"Nothing to do, this will always throw an exception"));
    }

    @Override
    public void getFCPAffectedByMetadataUser(ComplexDataTypeTestOuterClass.Get_FCPAffectedByMetadata_User_Parameters request, StreamObserver<ComplexDataTypeTestOuterClass.Get_FCPAffectedByMetadata_User_Responses> responseObserver) {
        responseObserver.onNext((Object)ComplexDataTypeTestOuterClass.Get_FCPAffectedByMetadata_User_Responses.newBuilder().addAffectedCalls(SiLAString.from((String)"org.silastandard/test/ComplexDatatypeTest/v1/Command/XOREncipher")).build());
        responseObserver.onCompleted();
    }

    private UUID XOREncipherSiLABinary(@NonNull UUID binaryIdentifier, byte key) throws BinaryDatabaseException, SQLException {
        if (binaryIdentifier == null) {
            throw new NullPointerException("binaryIdentifier is marked non-null but is null");
        }
        Binary binary = this.binaryDatabase.getBinary(binaryIdentifier);
        UUID xorBinaryId = UUID.randomUUID();
        try (ByteArrayProcessedInputStream byteArrayProcessedInputStream = new ByteArrayProcessedInputStream(binary.getData().getBinaryStream(), (bytes, off, len) -> Bytes.XOREncipherBytes(bytes, key, off, len));){
            this.binaryDatabase.addBinary(xorBinaryId, (InputStream)byteArrayProcessedInputStream, "ch.unitelabs/test/UnobservableCommandTest/v1/Command/XOREncipher/Parameter/Data");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return xorBinaryId;
    }

    private static List<String> getNewList() {
        ArrayList<String> listString = new ArrayList<String>();
        Random random = new Random();
        int listLength = random.nextInt(STRING_ARRAY.length);
        for (int i = 0; i < listLength; ++i) {
            listString.add(STRING_ARRAY[random.nextInt(STRING_ARRAY.length)]);
        }
        return listString;
    }

    static {
        for (int i = 0; i < 1000; ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int j = 0; j < i % 5; ++j) {
                stringBuilder.append(STRING_ARRAY[(i >> j) % STRING_ARRAY.length]).append(" ");
            }
            HUGE_LIST.add(SiLAString.from((String)stringBuilder.toString()));
        }
        LIST_STRING_RESPONSE = ComplexDataTypeTestOuterClass.Get_ListString_Responses.newBuilder().addListString(SiLAString.from((String)"White")).addListString(SiLAString.from((String)"Rabbit")).build();
        LIST_STRUCT_PAIR_STRING_RESPONSE = ComplexDataTypeTestOuterClass.Get_ListStructPairString_Responses.newBuilder().addListStructPairString(ComplexDataTypeTestOuterClass.Get_ListStructPairString_Responses.ListStructPairString_Struct.newBuilder().setKey(SiLAString.from((String)"Unite")).setValue(SiLAString.from((String)"Labs")).build()).addListStructPairString(ComplexDataTypeTestOuterClass.Get_ListStructPairString_Responses.ListStructPairString_Struct.newBuilder().setKey(SiLAString.from((String)"SiLA")).setValue(SiLAString.from((String)"Standard")).build()).build();
        STRUCT_PAIR_STRING_RESPONSE = ComplexDataTypeTestOuterClass.Get_StructPairString_Responses.newBuilder().setStructPairString(ComplexDataTypeTestOuterClass.Get_StructPairString_Responses.StructPairString_Struct.newBuilder().setPairString(ComplexDataTypeTestOuterClass.Get_StructPairString_Responses.StructPairString_Struct.PairString_Struct.newBuilder().setKey(SiLAString.from((String)"AKey")).setValue(SiLAString.from((String)"AValue")).build()).build()).build();
        DATA_TYPE_RESPONSE = ComplexDataTypeTestOuterClass.Get_DataType_Responses.newBuilder().setDataType(ComplexDataTypeTestOuterClass.DataType_DataTypeString.newBuilder().setDataTypeString(SiLAString.from((String)"blah")).build()).build();
    }
}

