/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.test_server.impl;

import io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.ch.unitelabs.test.unobservablecommandtest.v1.UnobservableCommandTestGrpc;
import sila2.ch.unitelabs.test.unobservablecommandtest.v1.UnobservableCommandTestOuterClass;
import sila_java.library.core.sila.errors.SiLAErrors;
import sila_java.library.core.sila.types.SiLAString;
import sila_java.library.server_base.metadata.MetadataExtractingInterceptor;
import sila_java.library.server_base.metadata.ServerMetadataContainer;

public class UnobservableCommand
extends UnobservableCommandTestGrpc.UnobservableCommandTestImplBase {
    private static final Logger log = LoggerFactory.getLogger(UnobservableCommand.class);
    private static final String FULLY_QUALIFIED_FEATURE_IDENTIFIER = "ch.unitelabs/test/UnobservableCommand/v1";
    public static final UnobservableCommandTestOuterClass.MakeCoffee_Responses MAKE_COFFEE_RESPONSE = UnobservableCommandTestOuterClass.MakeCoffee_Responses.newBuilder().setResult(SiLAString.from((String)"Your coffee is ready!")).build();

    @Override
    public void makeCoffee(UnobservableCommandTestOuterClass.MakeCoffee_Parameters request, StreamObserver<UnobservableCommandTestOuterClass.MakeCoffee_Responses> responseObserver) {
        ServerMetadataContainer serverMetadataContainer = (ServerMetadataContainer)MetadataExtractingInterceptor.SILA_METADATA_KEY.get();
        UnobservableCommandTestOuterClass.Metadata_User metadataUser = (UnobservableCommandTestOuterClass.Metadata_User)serverMetadataContainer.get(UnobservableCommandTestOuterClass.Metadata_User.class);
        if (metadataUser != null && metadataUser.hasUser()) {
            log.info("received metadata user: " + metadataUser.getUser().getIdentifier());
        } else {
            log.info("User metadata was not provided");
        }
        if (request.getSugar().getValue()) {
            responseObserver.onError((Throwable)SiLAErrors.generateDefinedExecutionError((String)"ch.unitelabs/test/UnobservableCommand/v1/DefinedExecutionError/SugarException", (String)"Sorry, there is no more sugar! Buy some sugar or take your coffee without sugar"));
            return;
        }
        responseObserver.onNext((Object)MAKE_COFFEE_RESPONSE);
        responseObserver.onCompleted();
    }

    @Override
    public void sleep(UnobservableCommandTestOuterClass.Sleep_Parameters request, StreamObserver<UnobservableCommandTestOuterClass.Sleep_Responses> responseObserver) {
        try {
            Thread.sleep(request.getSecondsToSleep().getValue() * 1000L);
        }
        catch (InterruptedException e) {
            log.warn("sleep interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        responseObserver.onNext((Object)UnobservableCommandTestOuterClass.Sleep_Responses.newBuilder().build());
        responseObserver.onCompleted();
    }

    @Override
    public void getFCPAffectedByMetadataUser(UnobservableCommandTestOuterClass.Get_FCPAffectedByMetadata_User_Parameters request, StreamObserver<UnobservableCommandTestOuterClass.Get_FCPAffectedByMetadata_User_Responses> responseObserver) {
        responseObserver.onNext((Object)UnobservableCommandTestOuterClass.Get_FCPAffectedByMetadata_User_Responses.newBuilder().addAffectedCalls(SiLAString.from((String)"ch.unitelabs/test/UnobservableCommandTest/v1/Command/MakeCoffee")).build());
        responseObserver.onCompleted();
    }
}

