/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.test_server.sila_base.impl;

import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLAFramework;
import sila2.org.silastandard.test.observablecommandtest.v1.ObservableCommandTestGrpc;
import sila2.org.silastandard.test.observablecommandtest.v1.ObservableCommandTestOuterClass;
import sila_java.library.core.sila.errors.SiLAErrors;
import sila_java.library.core.sila.types.SiLAInteger;
import sila_java.library.server_base.command.observable.ObservableCommandManager;
import sila_java.library.server_base.command.observable.ObservableCommandTaskRunner;
import sila_java.library.server_base.command.observable.ObservableCommandWrapper;
import sila_java.library.server_base.command.observable.RunnableCommandTask;

public class ObservableCommandTest
extends ObservableCommandTestGrpc.ObservableCommandTestImplBase
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ObservableCommandTest.class);
    private final ObservableCommandManager<ObservableCommandTestOuterClass.Count_Parameters, ObservableCommandTestOuterClass.Count_Responses> countCommandManager = new ObservableCommandManager(new ObservableCommandTaskRunner(1, 8), (RunnableCommandTask)new RunnableCommandTask<ObservableCommandTestOuterClass.Count_Parameters, ObservableCommandTestOuterClass.Count_Responses>(){

        public ObservableCommandTestOuterClass.Count_Responses run(ObservableCommandWrapper<ObservableCommandTestOuterClass.Count_Parameters, ObservableCommandTestOuterClass.Count_Responses> command) throws StatusRuntimeException {
            double delay = ((ObservableCommandTestOuterClass.Count_Parameters)command.getParameter()).getDelay().getValue();
            long nbIterations = ((ObservableCommandTestOuterClass.Count_Parameters)command.getParameter()).getN().getValue();
            try {
                int i = 0;
                while ((long)i < nbIterations) {
                    Thread.sleep((long)(1000.0 * delay));
                    command.setExecutionInfoAndNotify((double)i / ((double)nbIterations - 1.0), Duration.ofSeconds((long)(delay * (double)(nbIterations - (long)i - 1L))));
                    command.notifyIntermediateResponse((Object)ObservableCommandTestOuterClass.Count_IntermediateResponses.newBuilder().setCurrentIteration(SiLAInteger.from((long)i)).build());
                    ++i;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return ObservableCommandTestOuterClass.Count_Responses.newBuilder().setIterationResponse(SiLAInteger.from((long)(nbIterations - 1L))).build();
        }

        public void validate(ObservableCommandTestOuterClass.Count_Parameters parameters) throws StatusRuntimeException {
            if (!parameters.hasDelay()) {
                throw SiLAErrors.generateValidationError((String)"org.silastandard/test/ObservableCommandTest/v1/Command/Count/Parameter/Delay", (String)"Missing parameter.");
            }
            if (!parameters.hasN()) {
                throw SiLAErrors.generateValidationError((String)"org.silastandard/test/ObservableCommandTest/v1/Command/Count/Parameter/N", (String)"Missing parameter.");
            }
        }
    }, Duration.ofSeconds(60L));
    private final ObservableCommandManager<ObservableCommandTestOuterClass.EchoValueAfterDelay_Parameters, ObservableCommandTestOuterClass.EchoValueAfterDelay_Responses> echoValueCommandManager = new ObservableCommandManager(new ObservableCommandTaskRunner(1, 8), (RunnableCommandTask)new RunnableCommandTask<ObservableCommandTestOuterClass.EchoValueAfterDelay_Parameters, ObservableCommandTestOuterClass.EchoValueAfterDelay_Responses>(){

        public ObservableCommandTestOuterClass.EchoValueAfterDelay_Responses run(ObservableCommandWrapper<ObservableCommandTestOuterClass.EchoValueAfterDelay_Parameters, ObservableCommandTestOuterClass.EchoValueAfterDelay_Responses> command) throws StatusRuntimeException {
            return ObservableCommandTestOuterClass.EchoValueAfterDelay_Responses.newBuilder().setReceivedValue(((ObservableCommandTestOuterClass.EchoValueAfterDelay_Parameters)command.getParameter()).getValue()).build();
        }

        public void preRun(ObservableCommandTestOuterClass.EchoValueAfterDelay_Parameters parameters, UUID commandExecutionUUID) {
            double delay = parameters.getDelay().getValue();
            try {
                Thread.sleep((long)delay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        public void validate(ObservableCommandTestOuterClass.EchoValueAfterDelay_Parameters parameters) throws StatusRuntimeException {
            if (!parameters.hasDelay()) {
                throw SiLAErrors.generateValidationError((String)"org.silastandard/test/ObservableCommandTest/v1/Command/EchoValueAfterDelay/Parameter/Delay", (String)"Missing parameter.");
            }
            if (!parameters.hasValue()) {
                throw SiLAErrors.generateValidationError((String)"org.silastandard/test/ObservableCommandTest/v1/Command/EchoValueAfterDelay/Parameter/Value", (String)"Missing parameter.");
            }
        }
    }, Duration.ofSeconds(60L));

    @Override
    public void count(ObservableCommandTestOuterClass.Count_Parameters request, StreamObserver<SiLAFramework.CommandConfirmation> responseObserver) {
        this.countCommandManager.addCommand((Object)request, responseObserver);
    }

    @Override
    public void countInfo(SiLAFramework.CommandExecutionUUID request, StreamObserver<SiLAFramework.ExecutionInfo> responseObserver) {
        this.countCommandManager.get(request).addStateObserver(responseObserver);
    }

    @Override
    public void countIntermediate(SiLAFramework.CommandExecutionUUID request, StreamObserver<ObservableCommandTestOuterClass.Count_IntermediateResponses> responseObserver) {
        this.countCommandManager.get(request).addIntermediateResponseObserver(responseObserver);
    }

    @Override
    public void countResult(SiLAFramework.CommandExecutionUUID request, StreamObserver<ObservableCommandTestOuterClass.Count_Responses> responseObserver) {
        this.countCommandManager.get(request).sendResult(responseObserver);
    }

    @Override
    public void echoValueAfterDelay(ObservableCommandTestOuterClass.EchoValueAfterDelay_Parameters request, StreamObserver<SiLAFramework.CommandConfirmation> responseObserver) {
        this.echoValueCommandManager.addCommand((Object)request, responseObserver);
    }

    @Override
    public void echoValueAfterDelayInfo(SiLAFramework.CommandExecutionUUID request, StreamObserver<SiLAFramework.ExecutionInfo> responseObserver) {
        this.echoValueCommandManager.get(request).addStateObserver(responseObserver);
    }

    @Override
    public void echoValueAfterDelayResult(SiLAFramework.CommandExecutionUUID request, StreamObserver<ObservableCommandTestOuterClass.EchoValueAfterDelay_Responses> responseObserver) {
        this.echoValueCommandManager.get(request).sendResult(responseObserver);
    }

    @Override
    public void close() {
        this.echoValueCommandManager.close();
        this.countCommandManager.close();
    }
}

