/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.test_server.sila_base.impl;

import io.grpc.stub.StreamObserver;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.test.observablepropertytest.v1.ObservablePropertyTestGrpc;
import sila2.org.silastandard.test.observablepropertytest.v1.ObservablePropertyTestOuterClass;
import sila_java.library.core.sila.errors.SiLAErrors;
import sila_java.library.core.sila.types.SiLABoolean;
import sila_java.library.core.sila.types.SiLAInteger;

public class ObservablePropertyTest
extends ObservablePropertyTestGrpc.ObservablePropertyTestImplBase
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ObservablePropertyTest.class);
    private static final int FIXED_VALUE = 42;
    private final Set<Runnable> editableListeners = new HashSet<Runnable>();
    private final Set<Runnable> alternatingListeners = new HashSet<Runnable>();
    private final Set<StreamObserver<ObservablePropertyTestOuterClass.Subscribe_FixedValue_Responses>> fixedListeners = new HashSet<StreamObserver<ObservablePropertyTestOuterClass.Subscribe_FixedValue_Responses>>();
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private final AtomicLong editableValue = new AtomicLong(0L);
    private final AtomicBoolean alternatingValue = new AtomicBoolean(false);

    public ObservablePropertyTest() {
        this.executor.scheduleAtFixedRate(() -> {
            this.alternatingValue.set(!this.alternatingValue.get());
            this.notifyAlternatingListeners();
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    private void notifyEditableListeners() {
        HashSet toRemove = new HashSet();
        this.editableListeners.forEach(listener -> {
            try {
                listener.run();
            }
            catch (Exception e) {
                log.debug("Remove editable observable property listener because of exception", (Throwable)e);
                toRemove.add(listener);
            }
        });
        this.editableListeners.removeAll(toRemove);
        log.debug("Editable observable property listeners count {}", (Object)this.editableListeners.size());
    }

    private void notifyAlternatingListeners() {
        HashSet toRemove = new HashSet();
        this.alternatingListeners.forEach(listener -> {
            try {
                listener.run();
            }
            catch (Exception e) {
                log.debug("Remove alternating observable property listener because of exception", (Throwable)e);
                toRemove.add(listener);
            }
        });
        this.alternatingListeners.removeAll(toRemove);
        log.debug("Alternating observable property listeners count {}", (Object)this.alternatingListeners.size());
    }

    @Override
    public void setValue(ObservablePropertyTestOuterClass.SetValue_Parameters request, StreamObserver<ObservablePropertyTestOuterClass.SetValue_Responses> responseObserver) {
        if (!request.hasValue()) {
            throw SiLAErrors.generateValidationError((String)"org.silastandard/test/ObservablePropertyTest/v1/Command/SetValue/Parameter/Value", (String)"Missing parameter.");
        }
        this.editableValue.set(request.getValue().getValue());
        responseObserver.onNext((Object)ObservablePropertyTestOuterClass.SetValue_Responses.newBuilder().build());
        this.notifyEditableListeners();
        responseObserver.onCompleted();
    }

    @Override
    public void subscribeFixedValue(ObservablePropertyTestOuterClass.Subscribe_FixedValue_Parameters request, StreamObserver<ObservablePropertyTestOuterClass.Subscribe_FixedValue_Responses> responseObserver) {
        this.fixedListeners.add(responseObserver);
        responseObserver.onNext((Object)ObservablePropertyTestOuterClass.Subscribe_FixedValue_Responses.newBuilder().setFixedValue(SiLAInteger.from((long)42L)).build());
    }

    @Override
    public void subscribeAlternating(ObservablePropertyTestOuterClass.Subscribe_Alternating_Parameters request, StreamObserver<ObservablePropertyTestOuterClass.Subscribe_Alternating_Responses> responseObserver) {
        Runnable callback = () -> {
            try {
                responseObserver.onNext((Object)ObservablePropertyTestOuterClass.Subscribe_Alternating_Responses.newBuilder().setAlternating(SiLABoolean.from((boolean)this.alternatingValue.get())).build());
            }
            catch (Exception e) {
                responseObserver.onCompleted();
                throw e;
            }
        };
        callback.run();
        this.alternatingListeners.add(callback);
    }

    @Override
    public void subscribeEditable(ObservablePropertyTestOuterClass.Subscribe_Editable_Parameters request, StreamObserver<ObservablePropertyTestOuterClass.Subscribe_Editable_Responses> responseObserver) {
        Runnable callback = () -> {
            try {
                responseObserver.onNext((Object)ObservablePropertyTestOuterClass.Subscribe_Editable_Responses.newBuilder().setEditable(SiLAInteger.from((long)this.editableValue.get())).build());
            }
            catch (Exception e) {
                responseObserver.onCompleted();
                throw e;
            }
        };
        callback.run();
        this.editableListeners.add(callback);
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
        this.alternatingListeners.clear();
        this.editableListeners.clear();
        this.fixedListeners.clear();
    }
}

