/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.test_server.impl;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import io.grpc.stub.StreamObserver;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.ch.unitelabs.test.unobservablecommandtest.v1.UnobservableCommandTestGrpc;
import sila2.ch.unitelabs.test.unobservablecommandtest.v1.UnobservableCommandTestOuterClass;
import sila2.org.silastandard.SiLAFramework;
import sila_java.examples.test_server.utils.Bytes;
import sila_java.library.core.models.BasicType;
import sila_java.library.core.models.DataTypeType;
import sila_java.library.core.models.SiLAElement;
import sila_java.library.core.models.StructureType;
import sila_java.library.core.sila.errors.SiLAErrors;
import sila_java.library.core.sila.mapping.feature.MalformedSiLAFeature;
import sila_java.library.core.sila.mapping.grpc.ProtoMapper;
import sila_java.library.core.sila.types.SiLAAny;
import sila_java.library.core.sila.types.SiLABinary;
import sila_java.library.core.sila.types.SiLAInteger;
import sila_java.library.core.sila.types.SiLAReal;
import sila_java.library.core.sila.types.SiLAString;
import sila_java.library.core.utils.ByteArrayProcessedInputStream;
import sila_java.library.server_base.Constants;
import sila_java.library.server_base.FullyQualifiedMetadataContextKey;
import sila_java.library.server_base.binary_transfer.Binary;
import sila_java.library.server_base.binary_transfer.database.BinaryDatabase;
import sila_java.library.server_base.binary_transfer.database.BinaryDatabaseException;

public class UnobservableCommand
extends UnobservableCommandTestGrpc.UnobservableCommandTestImplBase {
    private static final Logger log = LoggerFactory.getLogger(UnobservableCommand.class);
    public static final UnobservableCommandTestOuterClass.MakeCoffee_Responses MAKE_COFFEE_RESPONSE = UnobservableCommandTestOuterClass.MakeCoffee_Responses.newBuilder().setResult(SiLAString.from((String)"Your coffee is ready!")).build();
    public static final UnobservableCommandTestOuterClass.WhyMakeItSimpleWhenYouCanMakeItComplicated_Responses COMPLICATED_RESPONSES = UnobservableCommandTestOuterClass.WhyMakeItSimpleWhenYouCanMakeItComplicated_Responses.newBuilder().setFirstResponse(SiLAString.from((String)"Dead")).setSecondResponse(SiLAString.from((String)"Alive")).build();
    public static final UnobservableCommandTestOuterClass.ThreeDimensionalStruct_Responses THREE_DIMENSIONAL_STRUCT_RESPONSES = UnobservableCommandTestOuterClass.ThreeDimensionalStruct_Responses.newBuilder().setThreeDimensionalListResult(UnobservableCommandTestOuterClass.DataType_ThreeDimensionalString.newBuilder().addThreeDimensionalString(UnobservableCommandTestOuterClass.DataType_TwoDimensionalString.newBuilder().addTwoDimensionalString(UnobservableCommandTestOuterClass.DataType_OneDimensionalString.newBuilder().addOneDimensionalString(SiLAString.from((String)"000")).build()).build())).build();
    public static final UnobservableCommandTestOuterClass.ThreeDimensionalList_Responses THREE_DIMENSIONAL_LIST_RESPONSES = UnobservableCommandTestOuterClass.ThreeDimensionalList_Responses.newBuilder().setThreeDimensionalStructResult(UnobservableCommandTestOuterClass.ThreeDimensionalList_Responses.ThreeDimensionalStructResult_Struct.newBuilder().setFirstDimension(UnobservableCommandTestOuterClass.ThreeDimensionalList_Responses.ThreeDimensionalStructResult_Struct.FirstDimension_Struct.newBuilder().setSecondDimension(UnobservableCommandTestOuterClass.ThreeDimensionalList_Responses.ThreeDimensionalStructResult_Struct.FirstDimension_Struct.SecondDimension_Struct.newBuilder().setThirdDimension(SiLAString.from((String)"111")).build()).build()).build()).build();
    private final BinaryDatabase binaryDatabase;

    public UnobservableCommand(@NonNull BinaryDatabase binaryDatabase) {
        if (binaryDatabase == null) {
            throw new NullPointerException("binaryDatabase is marked non-null but is null");
        }
        this.binaryDatabase = binaryDatabase;
    }

    public void makeCoffee(UnobservableCommandTestOuterClass.MakeCoffee_Parameters request, StreamObserver<UnobservableCommandTestOuterClass.MakeCoffee_Responses> responseObserver) {
        Set fullyQualifiedMetadataContextKeys = (Set)Constants.METADATA_IDENTIFIERS_CTX_KEY.get();
        Optional<FullyQualifiedMetadataContextKey> optionalUser = fullyQualifiedMetadataContextKeys.stream().filter(k -> k.getFullyQualifiedIdentifier().endsWith("User")).findAny();
        if (optionalUser.isPresent()) {
            try {
                UnobservableCommandTestOuterClass.Metadata_User user = UnobservableCommandTestOuterClass.Metadata_User.parseFrom((byte[])((byte[])optionalUser.get().getContextKey().get()));
                log.info("received metadata user: " + user.getUser().getIdentifier());
            }
            catch (InvalidProtocolBufferException e) {
                log.info("failed to parse metadata user", (Throwable)e);
            }
        } else {
            log.info("user metadata was not provided");
        }
        if (request.getSugar().getValue()) {
            responseObserver.onError((Throwable)SiLAErrors.generateDefinedExecutionError((String)"SugarException", (String)"Sorry, there is no more sugar! Buy some sugar or take your coffee without sugar"));
            return;
        }
        responseObserver.onNext((Object)MAKE_COFFEE_RESPONSE);
        responseObserver.onCompleted();
    }

    public void whyMakeItSimpleWhenYouCanMakeItComplicated(UnobservableCommandTestOuterClass.WhyMakeItSimpleWhenYouCanMakeItComplicated_Parameters request, StreamObserver<UnobservableCommandTestOuterClass.WhyMakeItSimpleWhenYouCanMakeItComplicated_Responses> responseObserver) {
        responseObserver.onNext((Object)COMPLICATED_RESPONSES);
        responseObserver.onCompleted();
    }

    public void threeDimensionalStruct(UnobservableCommandTestOuterClass.ThreeDimensionalStruct_Parameters request, StreamObserver<UnobservableCommandTestOuterClass.ThreeDimensionalStruct_Responses> responseObserver) {
        responseObserver.onNext((Object)THREE_DIMENSIONAL_STRUCT_RESPONSES);
        responseObserver.onCompleted();
    }

    public void threeDimensionalList(UnobservableCommandTestOuterClass.ThreeDimensionalList_Parameters request, StreamObserver<UnobservableCommandTestOuterClass.ThreeDimensionalList_Responses> responseObserver) {
        responseObserver.onNext((Object)THREE_DIMENSIONAL_LIST_RESPONSES);
        responseObserver.onCompleted();
    }

    public void xOREncipher(UnobservableCommandTestOuterClass.XOREncipher_Parameters request, StreamObserver<UnobservableCommandTestOuterClass.XOREncipher_Responses> responseObserver) {
        byte key = (byte)request.getCipherKey().getValue();
        if (!request.getData().getBinaryTransferUUID().isEmpty()) {
            try {
                UUID uuid = this.XOREncipherSiLABinary(UUID.fromString(request.getData().getBinaryTransferUUID()), key);
                responseObserver.onNext((Object)UnobservableCommandTestOuterClass.XOREncipher_Responses.newBuilder().setData(SiLABinary.fromBinaryTransferUUID((UUID)uuid)).build());
            }
            catch (SQLException | BinaryDatabaseException e) {
                log.error("Error happened while applying XOR Cipher on SiLA Binary {}", (Object)request.getData().getBinaryTransferUUID(), (Object)e);
                responseObserver.onError(e);
                return;
            }
        } else {
            byte[] data = request.getData().getValue().toByteArray();
            Bytes.XOREncipherBytes((byte[])data, (byte)key, (int)0, (int)data.length);
            responseObserver.onNext((Object)UnobservableCommandTestOuterClass.XOREncipher_Responses.newBuilder().setData(SiLABinary.fromBytes((byte[])data)).build());
        }
        responseObserver.onCompleted();
    }

    private UUID XOREncipherSiLABinary(@NonNull UUID binaryIdentifier, byte key) throws BinaryDatabaseException, SQLException {
        if (binaryIdentifier == null) {
            throw new NullPointerException("binaryIdentifier is marked non-null but is null");
        }
        Binary binary = this.binaryDatabase.getBinary(binaryIdentifier);
        UUID xorBinaryId = UUID.randomUUID();
        ByteArrayProcessedInputStream byteArrayProcessedInputStream = new ByteArrayProcessedInputStream(binary.getData().getBinaryStream(), (bytes, off, len) -> Bytes.XOREncipherBytes((byte[])bytes, (byte)key, (int)off, (int)len));
        this.binaryDatabase.addBinary(xorBinaryId, (InputStream)byteArrayProcessedInputStream);
        return xorBinaryId;
    }

    public void valueForTypeProvider(UnobservableCommandTestOuterClass.ValueForTypeProvider_Parameters request, StreamObserver<UnobservableCommandTestOuterClass.ValueForTypeProvider_Responses> responseObserver) {
        SiLAFramework.Any any;
        DynamicMessage anonymousStructureMessage;
        DataTypeType integerType = new DataTypeType();
        integerType.setBasic(BasicType.INTEGER);
        DataTypeType anonymousStructureType = new DataTypeType();
        StructureType structureType = new StructureType();
        SiLAElement element = new SiLAElement();
        element.setDataType(integerType);
        element.setDescription("X");
        element.setDisplayName("X");
        element.setIdentifier("X");
        structureType.getElement().add(element);
        anonymousStructureType.setStructure(structureType);
        try {
            Descriptors.Descriptor anonymousStructureDescriptor = ProtoMapper.dataTypeToDescriptor((DataTypeType)anonymousStructureType);
            anonymousStructureMessage = DynamicMessage.newBuilder((Descriptors.Descriptor)anonymousStructureDescriptor).setField(anonymousStructureDescriptor.findFieldByName("X"), (Object)SiLAInteger.from((long)101L)).build();
        }
        catch (MalformedSiLAFeature e) {
            throw new RuntimeException(e);
        }
        switch (request.getType().getValue()) {
            case "Integer": {
                any = SiLAAny.from((DataTypeType)integerType, (Message)SiLAInteger.from((long)1337L));
                break;
            }
            case "String": {
                any = SiLAAny.from((String)"<DataType><Basic>String</Basic></DataType>", (Message)SiLAString.from((String)"test"));
                break;
            }
            case "ConstrainedReal": {
                any = SiLAAny.from((String)"<DataType><Constrained><DataType><Basic>Real</Basic></DataType><Constraints><MinimalInclusive>4.2</MinimalInclusive><MaximalInclusive>133.7</MaximalInclusive></Constraints></Constrained></DataType>", (Message)SiLAReal.from((double)7.7));
                break;
            }
            case "AnonymousStructure": {
                any = SiLAAny.from((DataTypeType)anonymousStructureType, (Message)anonymousStructureMessage);
                break;
            }
            case "AnonymousList": {
                any = SiLAAny.from((String)"<DataType><List><DataType><Basic>Any</Basic></DataType></List></DataType>", (Message)UnobservableCommandTestOuterClass.DataType_AnonymousList.newBuilder().addAnonymousList(SiLAAny.from((DataTypeType)integerType, (Message)SiLAInteger.from((long)777L))).addAnonymousList(SiLAAny.from((String)"<DataType><Basic>String</Basic></DataType>", (Message)SiLAString.from((String)"SiLA"))).build());
                break;
            }
            default: {
                responseObserver.onError((Throwable)SiLAErrors.generateUndefinedExecutionError((String)("Unsupported type: " + request.getType().getValue())));
                return;
            }
        }
        responseObserver.onNext((Object)UnobservableCommandTestOuterClass.ValueForTypeProvider_Responses.newBuilder().setAny(any).build());
        responseObserver.onCompleted();
    }

    public void getFCPAffectedByMetadataUser(UnobservableCommandTestOuterClass.Get_FCPAffectedByMetadata_User_Parameters request, StreamObserver<UnobservableCommandTestOuterClass.Get_FCPAffectedByMetadata_User_Responses> responseObserver) {
        responseObserver.onNext((Object)UnobservableCommandTestOuterClass.Get_FCPAffectedByMetadata_User_Responses.newBuilder().addAffectedCalls(SiLAString.from((String)"ch.unitelabs/test/UnobservableCommandTest/v1/Command/XOREncipher")).build());
        responseObserver.onCompleted();
    }

    public void sleep(UnobservableCommandTestOuterClass.Sleep_Parameters request, StreamObserver<UnobservableCommandTestOuterClass.Sleep_Responses> responseObserver) {
        try {
            Thread.sleep(request.getSecondsToSleep().getValue() * 1000L);
        }
        catch (InterruptedException e) {
            log.warn("sleep interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        responseObserver.onNext((Object)UnobservableCommandTestOuterClass.Sleep_Responses.newBuilder().build());
        responseObserver.onCompleted();
    }

    public void listProvider(UnobservableCommandTestOuterClass.ListProvider_Parameters request, StreamObserver<UnobservableCommandTestOuterClass.ListProvider_Responses> responseObserver) {
        long listLength = request.getListLength().getValue();
        long elementLength = request.getElementLength().getValue();
        ArrayList<SiLAFramework.String> list = new ArrayList<SiLAFramework.String>((int)listLength);
        int i = 0;
        while ((long)i < listLength) {
            list.add(i, SiLAString.from((String)RandomStringUtils.randomAlphanumeric((int)((int)elementLength))));
            ++i;
        }
        responseObserver.onNext((Object)UnobservableCommandTestOuterClass.ListProvider_Responses.newBuilder().addAllList(list).build());
        responseObserver.onCompleted();
    }
}

