/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.test_server.impl;

import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.ch.unitelabs.test.parameterconstraintsprovidertest.v1.ParameterConstraintsProviderTestGrpc;
import sila2.ch.unitelabs.test.parameterconstraintsprovidertest.v1.ParameterConstraintsProviderTestOuterClass;
import sila2.org.silastandard.SiLAFramework;
import sila_java.library.core.models.Constraints;
import sila_java.library.core.sila.errors.SiLAErrors;

public class ParameterConstraintsProvider
extends ParameterConstraintsProviderTestGrpc.ParameterConstraintsProviderTestImplBase {
    private static final Logger log = LoggerFactory.getLogger(ParameterConstraintsProvider.class);
    private static final String FULLY_QUALIFIED_POSITION_PARAMETER = "ch.unitelabs/test/v1/ParameterConstraintsTest/Command/GoToPos/Parameter/PositionIdentifier";
    private final Map<String, Position> positions = new HashMap<String, Position>();
    private final sila_java.library.server_base.standard_features.ParameterConstraintsProvider parameterConstraintProvider;

    public ParameterConstraintsProvider(@NonNull sila_java.library.server_base.standard_features.ParameterConstraintsProvider parameterConstraintProvider) {
        if (parameterConstraintProvider == null) {
            throw new NullPointerException("parameterConstraintProvider is marked non-null but is null");
        }
        this.parameterConstraintProvider = parameterConstraintProvider;
        this.loadPositions();
    }

    @Override
    public void goToPos(ParameterConstraintsProviderTestOuterClass.GoToPos_Parameters request, StreamObserver<ParameterConstraintsProviderTestOuterClass.GoToPos_Responses> responseObserver) {
        Constraints constraints = (Constraints)this.parameterConstraintProvider.getParametersConstraints().get(FULLY_QUALIFIED_POSITION_PARAMETER);
        List allowedPos = constraints.getSet().getValue();
        boolean match = allowedPos.stream().anyMatch(s -> s.equals(request.getPositionIdentifier().getValue()));
        if (!match) {
            throw SiLAErrors.generateUndefinedExecutionError((String)"Incorrect position");
        }
        responseObserver.onNext((Object)ParameterConstraintsProviderTestOuterClass.GoToPos_Responses.newBuilder().build());
        responseObserver.onCompleted();
    }

    @Override
    public void addPosition(ParameterConstraintsProviderTestOuterClass.AddPosition_Parameters request, StreamObserver<ParameterConstraintsProviderTestOuterClass.AddPosition_Responses> responseObserver) {
        ParameterConstraintsProviderTestOuterClass.DataType_Position.Position_Struct position = request.getPosition().getPosition();
        if (this.positions.containsKey(position.getIdentifier().getValue())) {
            throw SiLAErrors.generateUndefinedExecutionError((String)"Position already exist");
        }
        this.positions.put(position.getIdentifier().getValue(), new Position((int)position.getX().getValue(), (int)position.getY().getValue()));
        this.parameterConstraintProvider.putConstraint(FULLY_QUALIFIED_POSITION_PARAMETER, this.getConstraints());
        responseObserver.onNext((Object)ParameterConstraintsProviderTestOuterClass.AddPosition_Responses.newBuilder().build());
        responseObserver.onCompleted();
    }

    @Override
    public void removePosition(ParameterConstraintsProviderTestOuterClass.RemovePosition_Parameters request, StreamObserver<ParameterConstraintsProviderTestOuterClass.RemovePosition_Responses> responseObserver) {
        this.positions.remove(request.getIdentifier().getValue());
        this.parameterConstraintProvider.putConstraint(FULLY_QUALIFIED_POSITION_PARAMETER, this.getConstraints());
        responseObserver.onNext((Object)ParameterConstraintsProviderTestOuterClass.RemovePosition_Responses.newBuilder().build());
        responseObserver.onCompleted();
    }

    @Override
    public void getPositions(ParameterConstraintsProviderTestOuterClass.Get_Positions_Parameters request, StreamObserver<ParameterConstraintsProviderTestOuterClass.Get_Positions_Responses> responseObserver) {
        Set positionSet = this.positions.entrySet().stream().map(e -> ParameterConstraintsProviderTestOuterClass.DataType_Position.Position_Struct.newBuilder().setIdentifier(SiLAFramework.String.newBuilder().setValue((String)e.getKey()).build()).setX(SiLAFramework.Integer.newBuilder().setValue(((Position)e.getValue()).getX()).build()).setY(SiLAFramework.Integer.newBuilder().setValue(((Position)e.getValue()).getY()).build()).build()).map(p -> ParameterConstraintsProviderTestOuterClass.DataType_Position.newBuilder().setPosition((ParameterConstraintsProviderTestOuterClass.DataType_Position.Position_Struct)p).build()).collect(Collectors.toSet());
        responseObserver.onNext((Object)ParameterConstraintsProviderTestOuterClass.Get_Positions_Responses.newBuilder().addAllPositions(positionSet).build());
        responseObserver.onCompleted();
    }

    private Constraints getConstraints() {
        Constraints constraints = new Constraints();
        constraints.setSet(new Constraints.Set());
        constraints.getSet().getValue().addAll(this.positions.keySet());
        return constraints;
    }

    private void loadPositions() {
        log.info("Loading positions...");
        this.positions.put("pos1", new Position(42, 1337));
        this.positions.put("pos2", new Position(101, 7));
        this.parameterConstraintProvider.putConstraint(FULLY_QUALIFIED_POSITION_PARAMETER, this.getConstraints());
        log.info("{} positions loaded!", (Object)this.positions.size());
    }

    private static class Position {
        private int x;
        private int y;

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public Position(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

