/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.test_server;

import com.google.common.base.Verify;
import io.grpc.BindableService;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.CloudClientEndpointGrpc;
import sila_java.examples.test_server.impl.ObservableCommand;
import sila_java.examples.test_server.impl.ObservableProperty;
import sila_java.examples.test_server.impl.ParameterConstraints;
import sila_java.examples.test_server.impl.ParameterConstraintsProvider;
import sila_java.examples.test_server.impl.UnobservableCommand;
import sila_java.examples.test_server.impl.UnobservableProperty;
import sila_java.library.cloudier.server.CloudierConnectionConfigurationService;
import sila_java.library.cloudier.server.CloudierServerEndpoint;
import sila_java.library.cloudier.server.CloudierSiLAService;
import sila_java.library.cloudier.server.MessageCaseHandler;
import sila_java.library.core.sila.clients.ChannelFactory;
import sila_java.library.core.utils.FileUtils;
import sila_java.library.core.utils.Utils;
import sila_java.library.server_base.SiLAServer;
import sila_java.library.server_base.binary_transfer.database.BinaryDatabase;
import sila_java.library.server_base.identification.ServerInformation;
import sila_java.library.server_base.standard_features.FeatureImplementation;
import sila_java.library.server_base.utils.ArgumentHelper;
import sila_java.library.sila_base.EmptyClass;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestServer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(TestServer.class);
    static final String SERVER_TYPE = "Test Server";
    public static final ServerInformation serverInfo = new ServerInformation("Test Server", "Server for test purposes", "www.sila-standard.org", "v0.0");
    private final ObservableCommand observableCommandService = new ObservableCommand();
    private final UnobservableProperty unobservablePropertyService = new UnobservableProperty();
    private final ObservableProperty observablePropertyService = new ObservableProperty();
    private final UnobservableCommand unobservableCommandService;
    private final ParameterConstraintsProvider parameterConstraintsProviderService;
    private final sila_java.library.server_base.standard_features.ParameterConstraintsProvider parameterConstraintsProvider;
    private final ParameterConstraints parameterConstraintsTestService = new ParameterConstraints();
    private final CloudierConnectionConfigurationService connectionConfigurationService = new CloudierConnectionConfigurationService(false, arg_0 -> this.onServerConnectionModeChange(arg_0));
    private final SiLAServer.Builder builder;
    private final BinaryDatabase binaryDatabase;
    private SiLAServer clientInitiatedServer;
    private CloudierSiLAService cloudierSiLAService;
    private CloudClientEndpointGrpc.CloudClientEndpointStub clientEndpoint;
    private CloudierServerEndpoint cloudServerEndpointService;
    private ManagedChannel channel;
    private Thread serverInitiatedServerThread;

    private HashMap<String, MessageCaseHandler> getCallForwarderMap() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private static String getCoreFeatureContent(@NonNull String coreFeaturePath) {
        if (coreFeaturePath == null) {
            throw new NullPointerException("coreFeaturePath is marked non-null but is null");
        }
        return FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/core/" + coreFeaturePath)));
    }

    public TestServer(@NonNull ArgumentHelper argumentHelper) {
        if (argumentHelper == null) {
            throw new NullPointerException("argumentHelper is marked non-null but is null");
        }
        try {
            this.builder = argumentHelper.getConfigFile().isPresent() ? SiLAServer.Builder.withConfig((Path)((Path)argumentHelper.getConfigFile().get()), (ServerInformation)serverInfo) : SiLAServer.Builder.withoutConfig((ServerInformation)serverInfo);
            this.builder.withPersistedTLS(argumentHelper.getPrivateKeyFile(), argumentHelper.getCertificateFile(), argumentHelper.getCertificatePassword());
            argumentHelper.getPort().ifPresent(arg_0 -> ((SiLAServer.Builder)this.builder).withPort(arg_0));
            argumentHelper.getInterface().ifPresent(arg_0 -> ((SiLAServer.Builder)this.builder).withDiscovery(arg_0));
            if (argumentHelper.useUnsafeCommunication()) {
                this.builder.withUnsafeCommunication(true);
            }
            this.binaryDatabase = this.builder.withBinaryTransferSupport();
            this.unobservableCommandService = new UnobservableCommand(this.binaryDatabase);
            this.parameterConstraintsProvider = new sila_java.library.server_base.standard_features.ParameterConstraintsProvider();
            this.parameterConstraintsProviderService = new ParameterConstraintsProvider(this.parameterConstraintsProvider);
            this.builder.addFeature(FileUtils.getResourceContent((String)"features/UnobservablePropertyTest.sila.xml"), (BindableService)this.unobservablePropertyService).addFeature(FileUtils.getResourceContent((String)"features/ObservablePropertyTest.sila.xml"), (BindableService)this.observablePropertyService).addFeature(FileUtils.getResourceContent((String)"features/UnobservableCommandTest.sila.xml"), (BindableService)this.unobservableCommandService).addFeature(FileUtils.getResourceContent((String)"features/ObservableCommandTest.sila.xml"), (BindableService)this.observableCommandService).addFeature(FileUtils.getResourceContent((String)"features/ParameterConstraintsProviderTest.sila.xml"), (BindableService)this.parameterConstraintsProviderService).addFeature(FileUtils.getResourceContent((String)"features/ParameterConstraintsTest.sila.xml"), (BindableService)this.parameterConstraintsTestService).addFeature(TestServer.getCoreFeatureContent((String)"ConnectionConfigurationService.sila.xml"), (BindableService)this.connectionConfigurationService).addFeature((FeatureImplementation)this.parameterConstraintsProvider);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void startClientInitiatedServer() throws IOException {
        log.info("Starting server in client initiated mode");
        this.clientInitiatedServer = this.builder.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onServerConnectionModeChange(boolean serverInitiatedConnectionEnabled) {
        log.info("Server connection mode switching to {}", (Object)(serverInitiatedConnectionEnabled ? "Server Initiated" : "Client Initiated"));
        if (serverInitiatedConnectionEnabled) {
            try {
                this.clientInitiatedServer.close();
            }
            catch (Exception e) {
                log.warn("Exception occurred while closing client initiated server");
            }
            finally {
                this.clientInitiatedServer = null;
            }
        } else {
            try {
                this.channel.shutdown();
                try {
                    this.channel.awaitTermination(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    this.channel.shutdownNow();
                }
                Verify.verify((boolean)this.channel.isShutdown());
                this.serverInitiatedServerThread.interrupt();
                for (int i = 0; this.serverInitiatedServerThread.isAlive() && i < 50; ++i) {
                    Thread.sleep(100L);
                }
                if (this.serverInitiatedServerThread.isAlive()) {
                    this.serverInitiatedServerThread.stop();
                }
            }
            catch (Exception e) {
                log.warn("Exception occurred while closing server initiated server!");
            }
            finally {
                this.channel = null;
                this.cloudServerEndpointService = null;
                this.clientEndpoint = null;
                this.cloudierSiLAService = null;
                this.serverInitiatedServerThread = null;
            }
        }
        if (serverInitiatedConnectionEnabled) {
            this.startServerInitiatedConnection(this.builder.getServerConfig().getCacheConfig().getUuid());
        } else {
            try {
                this.startClientInitiatedServer();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        log.info("Server connection mode switched to {}", (Object)(serverInitiatedConnectionEnabled ? "Server Initiated" : "Client Initiated"));
    }

    private void startServerInitiatedConnection(@NonNull UUID serverUUID) {
        if (serverUUID == null) {
            throw new NullPointerException("serverUUID is marked non-null but is null");
        }
        this.serverInitiatedServerThread = new Thread(() -> {
            this.cloudierSiLAService = new CloudierSiLAService(this.builder.getServerConfig().getCacheConfig().getName(), serverInfo.getType(), serverUUID.toString(), serverInfo.getVersion(), serverInfo.getDescription(), serverInfo.getVendorURL(), this.builder.getFeatureDefinitions());
            this.channel = ChannelFactory.getTLSEncryptedChannel((String)"localhost", (int)50051);
            this.clientEndpoint = CloudClientEndpointGrpc.newStub((Channel)this.channel);
            this.cloudServerEndpointService = new CloudierServerEndpoint(this.cloudierSiLAService, this.connectionConfigurationService, this.clientEndpoint, (Map)this.getCallForwarderMap(), null, null);
        });
        this.serverInitiatedServerThread.start();
    }

    @Override
    public void close() {
        if (this.clientInitiatedServer != null) {
            this.clientInitiatedServer.close();
        }
        if (this.channel != null) {
            this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
        this.observableCommandService.close();
    }

    public static void main(String[] args) {
        ArgumentHelper argumentHelper = new ArgumentHelper(args, "Test Server");
        try (TestServer server = new TestServer(argumentHelper);){
            server.startClientInitiatedServer();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> server.close()));
            Utils.blockUntilStop();
        }
        log.info("Server closed.");
    }

    static /* synthetic */ ObservableCommand access$000(TestServer x0) {
        return x0.observableCommandService;
    }

    static /* synthetic */ ObservableProperty access$100(TestServer x0) {
        return x0.observablePropertyService;
    }

    static /* synthetic */ ParameterConstraintsProvider access$200(TestServer x0) {
        return x0.parameterConstraintsProviderService;
    }

    static /* synthetic */ UnobservableCommand access$300(TestServer x0) {
        return x0.unobservableCommandService;
    }

    static /* synthetic */ UnobservableProperty access$400(TestServer x0) {
        return x0.unobservablePropertyService;
    }

    static /* synthetic */ sila_java.library.server_base.standard_features.ParameterConstraintsProvider access$500(TestServer x0) {
        return x0.parameterConstraintsProvider;
    }
}

