/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.test_server;

import com.google.common.collect.ImmutableMap;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.BinaryDownloadGrpc;
import sila2.org.silastandard.BinaryUploadGrpc;
import sila2.org.silastandard.CloudClientEndpointGrpc;
import sila_java.examples.test_server.CloudTestServer;
import sila_java.examples.test_server.TestServer;
import sila_java.examples.test_server.impl.ObservableCommand;
import sila_java.examples.test_server.impl.ObservableProperty;
import sila_java.examples.test_server.impl.ParameterConstraints;
import sila_java.examples.test_server.impl.ParameterConstraintsProvider;
import sila_java.examples.test_server.impl.UnobservableCommand;
import sila_java.examples.test_server.impl.UnobservableProperty;
import sila_java.library.cloudier.server.CloudierConnectionConfigurationService;
import sila_java.library.cloudier.server.CloudierServerEndpoint;
import sila_java.library.cloudier.server.CloudierSiLAService;
import sila_java.library.core.sila.clients.ChannelFactory;
import sila_java.library.core.utils.FileUtils;
import sila_java.library.core.utils.Utils;
import sila_java.library.server_base.binary_transfer.database.BinaryDatabase;
import sila_java.library.server_base.binary_transfer.database.impl.H2BinaryDatabase;
import sila_java.library.server_base.binary_transfer.download.DownloadService;
import sila_java.library.server_base.binary_transfer.upload.UploadService;
import sila_java.library.sila_base.EmptyClass;

public class CloudTestServer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(CloudTestServer.class);
    private final CloudierSiLAService cloudierSiLAService;
    private final CloudierConnectionConfigurationService cloudierConnectionConfigurationService;
    private final ObservableCommand observableCommand = new ObservableCommand();
    private final UnobservableProperty unobservableProperty = new UnobservableProperty();
    private final ObservableProperty observableProperty = new ObservableProperty();
    private final UnobservableCommand unobservableCommand;
    private final sila_java.library.server_base.standard_features.ParameterConstraintsProvider ParameterConstraintsProvider = new sila_java.library.server_base.standard_features.ParameterConstraintsProvider();
    private final ParameterConstraintsProvider parameterConstraintsProvider = new ParameterConstraintsProvider(this.ParameterConstraintsProvider);
    private final ParameterConstraints parameterConstraints = new ParameterConstraints();
    private final BinaryDatabase binaryDatabase;
    private CloudClientEndpointGrpc.CloudClientEndpointStub clientEndpoint;
    private CloudierServerEndpoint cloudServerEndpointService;
    private ManagedChannel channel;

    public static void main(String[] args) throws Exception {
        UUID serverUUID = UUID.randomUUID();
        H2BinaryDatabase binaryDatabase = new H2BinaryDatabase(serverUUID);
        CloudTestServer cloudTestServer = new CloudTestServer(serverUUID, (BinaryDatabase)binaryDatabase);
        log.info("To stop the server press CTRL + C.");
        Utils.blockUntilShutdown(() -> CloudTestServer.lambda$main$0((BinaryDatabase)binaryDatabase, cloudTestServer));
    }

    public CloudTestServer(UUID serverUUID, BinaryDatabase binaryDatabase) throws IOException {
        this.binaryDatabase = binaryDatabase;
        this.unobservableCommand = new UnobservableCommand(binaryDatabase);
        ImmutableMap immutableMap = ImmutableMap.builder().put((Object)"SiLAService", (Object)FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/core/SiLAService.sila.xml")))).put((Object)"ConnectionConfigurationService", (Object)FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/core/ConnectionConfigurationService.sila.xml")))).put((Object)"ParameterConstraintsProvider", (Object)FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/core/commands/ParameterConstraintsProvider.sila.xml")))).put((Object)"ObservablePropertyTest", (Object)FileUtils.getFileContent((InputStream)Objects.requireNonNull(TestServer.class.getResourceAsStream("/features/ObservablePropertyTest.sila.xml")))).put((Object)"UnobservableCommandTest", (Object)FileUtils.getFileContent((InputStream)Objects.requireNonNull(TestServer.class.getResourceAsStream("/features/UnobservableCommandTest.sila.xml")))).put((Object)"ObservableCommandTest", (Object)FileUtils.getFileContent((InputStream)Objects.requireNonNull(TestServer.class.getResourceAsStream("/features/ObservableCommandTest.sila.xml")))).put((Object)"ParameterConstraintsProviderTest", (Object)FileUtils.getFileContent((InputStream)Objects.requireNonNull(TestServer.class.getResourceAsStream("/features/ParameterConstraintsProviderTest.sila.xml")))).put((Object)"UnobservablePropertyTest", (Object)FileUtils.getFileContent((InputStream)Objects.requireNonNull(TestServer.class.getResourceAsStream("/features/UnobservablePropertyTest.sila.xml")))).build();
        this.cloudierSiLAService = new CloudierSiLAService("Cloud Test Server", TestServer.SERVER_INFORMATION.getType(), serverUUID.toString(), TestServer.SERVER_INFORMATION.getVersion(), TestServer.SERVER_INFORMATION.getDescription(), TestServer.SERVER_INFORMATION.getVendorURL(), (Map)immutableMap);
        this.cloudierConnectionConfigurationService = new CloudierConnectionConfigurationService(false, connectionMode -> {});
        this.startServerInitiatedConnection();
    }

    private void startServerInitiatedConnection() {
        this.channel = ChannelFactory.getTLSEncryptedChannel((String)"127.0.0.1", (int)50051);
        this.clientEndpoint = CloudClientEndpointGrpc.newStub((Channel)this.channel);
        1 callForwarderMap = new /* Unavailable Anonymous Inner Class!! */;
        UploadService uploadService = new UploadService(this.binaryDatabase);
        DownloadService downloadService = new DownloadService(this.binaryDatabase);
        this.cloudServerEndpointService = new CloudierServerEndpoint(this.cloudierSiLAService, this.cloudierConnectionConfigurationService, this.clientEndpoint, (Map)callForwarderMap, (BinaryUploadGrpc.BinaryUploadImplBase)uploadService, (BinaryDownloadGrpc.BinaryDownloadImplBase)downloadService);
    }

    @Override
    public void close() {
        this.observableCommand.close();
        this.channel.shutdown();
    }

    private static /* synthetic */ void lambda$main$0(BinaryDatabase binaryDatabase, CloudTestServer cloudTestServer) {
        try {
            binaryDatabase.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        cloudTestServer.close();
    }

    static /* synthetic */ ObservableCommand access$000(CloudTestServer x0) {
        return x0.observableCommand;
    }

    static /* synthetic */ ObservableProperty access$100(CloudTestServer x0) {
        return x0.observableProperty;
    }

    static /* synthetic */ ParameterConstraintsProvider access$200(CloudTestServer x0) {
        return x0.parameterConstraintsProvider;
    }

    static /* synthetic */ UnobservableCommand access$300(CloudTestServer x0) {
        return x0.unobservableCommand;
    }

    static /* synthetic */ UnobservableProperty access$400(CloudTestServer x0) {
        return x0.unobservableProperty;
    }

    static /* synthetic */ sila_java.library.server_base.standard_features.ParameterConstraintsProvider access$500(CloudTestServer x0) {
        return x0.ParameterConstraintsProvider;
    }
}

