/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.test_server.impl;

import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.ch.unitelabs.test.unobservablepropertytest.v1.UnobservablePropertyTestGrpc;
import sila2.ch.unitelabs.test.unobservablepropertytest.v1.UnobservablePropertyTestOuterClass;
import sila2.org.silastandard.SiLAFramework;
import sila_java.library.core.sila.errors.SiLAErrors;
import sila_java.library.core.sila.types.SiLABoolean;
import sila_java.library.core.sila.types.SiLAString;

public class UnobservableProperty
extends UnobservablePropertyTestGrpc.UnobservablePropertyTestImplBase {
    private static final Logger log = LoggerFactory.getLogger(UnobservableProperty.class);
    public static final int NB_ELEMENT_HUGE_LIST = 1000;
    public static final String[] STRING_ARRAY = new String[]{"Switzerland", "Germany", "France", "Italy", "Finland", "Russia", "Latvia", "Lithuania", "Poland", "Portugal", "Follow", "the White", "Rabbit"};
    public static final List<SiLAFramework.String> HUGE_LIST = new ArrayList<SiLAFramework.String>(1000);
    public static final UnobservablePropertyTestOuterClass.Get_ListString_Responses LIST_STRING_RESPONSE;
    public static final UnobservablePropertyTestOuterClass.Get_ListStructPairString_Responses LIST_STRUCT_PAIR_STRING_RESPONSE;
    public static final UnobservablePropertyTestOuterClass.Get_StructPairString_Responses STRUCT_PAIR_STRING_RESPONSE;
    public static final UnobservablePropertyTestOuterClass.Get_DataType_Responses DATA_TYPE_RESPONSE;

    @Override
    public void getHugeList(UnobservablePropertyTestOuterClass.Get_HugeList_Parameters request, StreamObserver<UnobservablePropertyTestOuterClass.Get_HugeList_Responses> responseObserver) {
        responseObserver.onNext((Object)UnobservablePropertyTestOuterClass.Get_HugeList_Responses.newBuilder().addAllHugeList(HUGE_LIST).build());
        responseObserver.onCompleted();
    }

    @Override
    public void getBoolean(UnobservablePropertyTestOuterClass.Get_Boolean_Parameters request, StreamObserver<UnobservablePropertyTestOuterClass.Get_Boolean_Responses> responseObserver) {
        responseObserver.onNext((Object)UnobservablePropertyTestOuterClass.Get_Boolean_Responses.newBuilder().setBoolean(SiLABoolean.from((Math.random() < 0.5 ? 1 : 0) != 0)).build());
        responseObserver.onCompleted();
    }

    @Override
    public void getListString(UnobservablePropertyTestOuterClass.Get_ListString_Parameters request, StreamObserver<UnobservablePropertyTestOuterClass.Get_ListString_Responses> responseObserver) {
        responseObserver.onNext((Object)LIST_STRING_RESPONSE);
        responseObserver.onCompleted();
    }

    @Override
    public void getRandomChangingListString(UnobservablePropertyTestOuterClass.Get_RandomChangingListString_Parameters request, StreamObserver<UnobservablePropertyTestOuterClass.Get_RandomChangingListString_Responses> responseObserver) {
        UnobservablePropertyTestOuterClass.Get_RandomChangingListString_Responses.Builder newListRes = UnobservablePropertyTestOuterClass.Get_RandomChangingListString_Responses.newBuilder();
        UnobservableProperty.getNewList().forEach(item -> newListRes.addRandomChangingListString(SiLAString.from((String)item)));
        responseObserver.onNext((Object)newListRes.build());
        responseObserver.onCompleted();
    }

    @Override
    public void getListStructPairString(UnobservablePropertyTestOuterClass.Get_ListStructPairString_Parameters request, StreamObserver<UnobservablePropertyTestOuterClass.Get_ListStructPairString_Responses> responseObserver) {
        responseObserver.onNext((Object)LIST_STRUCT_PAIR_STRING_RESPONSE);
        responseObserver.onCompleted();
    }

    @Override
    public void getStructPairString(UnobservablePropertyTestOuterClass.Get_StructPairString_Parameters request, StreamObserver<UnobservablePropertyTestOuterClass.Get_StructPairString_Responses> responseObserver) {
        responseObserver.onNext((Object)STRUCT_PAIR_STRING_RESPONSE);
        responseObserver.onCompleted();
    }

    @Override
    public void getDataType(UnobservablePropertyTestOuterClass.Get_DataType_Parameters request, StreamObserver<UnobservablePropertyTestOuterClass.Get_DataType_Responses> responseObserver) {
        responseObserver.onNext((Object)DATA_TYPE_RESPONSE);
        responseObserver.onCompleted();
    }

    @Override
    public void getThrowException(UnobservablePropertyTestOuterClass.Get_ThrowException_Parameters request, StreamObserver<UnobservablePropertyTestOuterClass.Get_ThrowException_Responses> responseObserver) {
        responseObserver.onError((Throwable)SiLAErrors.generateDefinedExecutionError((String)"TestException", (String)"Nothing to do, this will always throw an exception"));
    }

    private static List<String> getNewList() {
        ArrayList<String> listString = new ArrayList<String>();
        Random random = new Random();
        int listLength = random.nextInt(STRING_ARRAY.length);
        for (int i = 0; i < listLength; ++i) {
            listString.add(STRING_ARRAY[random.nextInt(STRING_ARRAY.length)]);
        }
        return listString;
    }

    static {
        for (int i = 0; i < 1000; ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int j = 0; j < i % 5; ++j) {
                stringBuilder.append(STRING_ARRAY[(i >> j) % STRING_ARRAY.length]).append(" ");
            }
            HUGE_LIST.add(SiLAString.from((String)stringBuilder.toString()));
        }
        LIST_STRING_RESPONSE = UnobservablePropertyTestOuterClass.Get_ListString_Responses.newBuilder().addListString(SiLAString.from((String)"White")).addListString(SiLAString.from((String)"Rabbit")).build();
        LIST_STRUCT_PAIR_STRING_RESPONSE = UnobservablePropertyTestOuterClass.Get_ListStructPairString_Responses.newBuilder().addListStructPairString(UnobservablePropertyTestOuterClass.Get_ListStructPairString_Responses.ListStructPairString_Struct.newBuilder().setKey(SiLAString.from((String)"Unite")).setValue(SiLAString.from((String)"Labs")).build()).addListStructPairString(UnobservablePropertyTestOuterClass.Get_ListStructPairString_Responses.ListStructPairString_Struct.newBuilder().setKey(SiLAString.from((String)"SiLA")).setValue(SiLAString.from((String)"Standard")).build()).build();
        STRUCT_PAIR_STRING_RESPONSE = UnobservablePropertyTestOuterClass.Get_StructPairString_Responses.newBuilder().setStructPairString(UnobservablePropertyTestOuterClass.Get_StructPairString_Responses.StructPairString_Struct.newBuilder().setPairString(UnobservablePropertyTestOuterClass.Get_StructPairString_Responses.StructPairString_Struct.PairString_Struct.newBuilder().setKey(SiLAString.from((String)"AKey")).setValue(SiLAString.from((String)"AValue")).build()).build()).build();
        DATA_TYPE_RESPONSE = UnobservablePropertyTestOuterClass.Get_DataType_Responses.newBuilder().setDataType(UnobservablePropertyTestOuterClass.DataType_DataTypeString.newBuilder().setDataTypeString(SiLAString.from((String)"blah")).build()).build();
    }
}

