/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.thermostat;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThermostatSimulation {
    private static final Logger log = LoggerFactory.getLogger(ThermostatSimulation.class);
    public static final double KELVIN_PER_SECONDS = 1.0;
    public static final double UPDATE_INTERVAL = 1.0;
    public static final double KELVIN_ACCURACY = 1.0;
    public static final double KELVIN_RAMP = 1.0;
    private final AtomicDouble currentTemperature = new AtomicDouble(293.0);
    private final AtomicDouble targetTemperature = new AtomicDouble(293.0);
    private final List<TemperatureListener> temperatureListenerList = new CopyOnWriteArrayList<TemperatureListener>();
    private final Thread agentThread = new Thread((Runnable)new TemperatureChangeAgent(), ThermostatSimulation.class.getName() + "_" + TemperatureChangeAgent.class.getName());

    public ThermostatSimulation() {
        this.agentThread.setDaemon(true);
        this.agentThread.start();
    }

    public void addListener(@NonNull TemperatureListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.temperatureListenerList.add(listener);
    }

    public void removeListener(@NonNull TemperatureListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.temperatureListenerList.remove(listener);
    }

    public void setTargetTemperature(double targetTemperature) {
        this.targetTemperature.set(targetTemperature);
    }

    public double getCurrentTemperature() {
        return this.currentTemperature.get();
    }

    private class TemperatureChangeAgent
    implements Runnable {
        private TemperatureChangeAgent() {
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                long startTime = System.currentTimeMillis();
                double temperature = ThermostatSimulation.this.currentTemperature.get();
                double temperatureDifference = ThermostatSimulation.this.targetTemperature.get() - temperature;
                double absoluteTemperatureDifference = Math.abs(temperatureDifference);
                if (absoluteTemperatureDifference >= 1.0) {
                    if (1.0 > absoluteTemperatureDifference) {
                        ThermostatSimulation.this.currentTemperature.set(ThermostatSimulation.this.targetTemperature.get());
                    } else {
                        ThermostatSimulation.this.currentTemperature.getAndAdd(Math.signum(temperatureDifference) * 1.0);
                    }
                    ThermostatSimulation.this.temperatureListenerList.forEach(l -> l.onChange(temperature));
                }
                long remainingTime = TimeUnit.SECONDS.toMillis(1L) - (System.currentTimeMillis() - startTime);
                try {
                    if (remainingTime <= 0L) continue;
                    Thread.sleep(remainingTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            log.info("End of temperature change agent");
        }
    }

    public static interface TemperatureListener {
        public void onChange(double var1);
    }
}

