/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.thermostat;

import io.grpc.BindableService;
import java.io.IOException;
import java.io.InputStream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.examples.thermostat.ThermostatServer;
import sila_java.examples.thermostat.ThermostatSimulation;
import sila_java.library.core.utils.FileUtils;
import sila_java.library.server_base.SiLAServer;
import sila_java.library.server_base.identification.ServerInformation;
import sila_java.library.server_base.utils.ArgumentHelper;
import sila_java.library.sila_base.EmptyClass;

public class ThermostatServer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ThermostatServer.class);
    static final String SERVER_TYPE = "ThermostatServer";
    private static final int EXECUTION_LIFETIME = 1000;
    private static final String featureLocation = "/sila_base/feature_definitions/org/silastandard/examples/TemperatureController-v1_0.sila.xml";
    private final SiLAServer siLAServer;
    private final ThermostatSimulation thermostatSimulation = new ThermostatSimulation();
    private final TemperatureControlImpl temperatureControl = new TemperatureControlImpl(this.thermostatSimulation);
    public static ServerInformation serverInfo = new ServerInformation("ThermostatServer", "Simple Example of a Thermostat", "https://www.sila-standard.org", "0.0");

    public ThermostatServer(@NonNull ArgumentHelper argumentHelper) {
        if (argumentHelper == null) {
            throw new NullPointerException("argumentHelper is marked non-null but is null");
        }
        try {
            SiLAServer.Builder builder = SiLAServer.Builder.newBuilder((ServerInformation)serverInfo);
            builder.withPersistentConfig(argumentHelper.getConfigFile().isPresent());
            argumentHelper.getConfigFile().ifPresent(arg_0 -> ((SiLAServer.Builder)builder).withPersistentConfigFile(arg_0));
            builder.withPersistentTLS(argumentHelper.getPrivateKeyFile(), argumentHelper.getCertificateFile(), argumentHelper.getCertificatePassword());
            argumentHelper.getHost().ifPresent(arg_0 -> ((SiLAServer.Builder)builder).withHost(arg_0));
            argumentHelper.getPort().ifPresent(arg_0 -> ((SiLAServer.Builder)builder).withPort(arg_0));
            argumentHelper.getInterface().ifPresent(arg_0 -> ((SiLAServer.Builder)builder).withNetworkInterface(arg_0));
            if (argumentHelper.useUnsafeCommunication()) {
                builder.withUnsafeCommunication(true);
            }
            builder.addFeature(FileUtils.getFileContent((InputStream)EmptyClass.class.getResourceAsStream(featureLocation)), (BindableService)this.temperatureControl);
            this.siLAServer = builder.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.temperatureControl.temperatureManager.close();
        this.siLAServer.close();
    }

    public static void main(String[] args) {
        ArgumentHelper argumentHelper = new ArgumentHelper(args, SERVER_TYPE);
        ThermostatServer server = new ThermostatServer(argumentHelper);
        log.info("To stop the server press CTRL + C.");
        server.siLAServer.blockUntilShutdown();
        System.out.println("termination complete.");
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

