/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.thermostat;

import io.grpc.BindableService;
import io.grpc.Context;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLAFramework;
import sila2.org.silastandard.examples.temperaturecontroller.v1.TemperatureControllerGrpc;
import sila2.org.silastandard.examples.temperaturecontroller.v1.TemperatureControllerOuterClass;
import sila_java.examples.thermostat.ThermostatSimulation;
import sila_java.library.core.sila.errors.SiLAErrors;
import sila_java.library.core.sila.types.SiLAReal;
import sila_java.library.core.utils.FileUtils;
import sila_java.library.core.utils.Utils;
import sila_java.library.server_base.SiLAServer;
import sila_java.library.server_base.command.observable.ObservableCommandManager;
import sila_java.library.server_base.command.observable.ObservableCommandTaskRunner;
import sila_java.library.server_base.command.observable.ObservableCommandWrapper;
import sila_java.library.server_base.identification.ServerInformation;
import sila_java.library.server_base.utils.ArgumentHelper;
import sila_java.library.sila_base.EmptyClass;

public class ThermostatServer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ThermostatServer.class);
    static final String SERVER_TYPE = "Thermostat Server";
    private static final int EXECUTION_LIFETIME = 1000;
    private static final String featureLocation = "/sila_base/feature_definitions/org/silastandard/examples/TemperatureController.sila.xml";
    private final SiLAServer siLAServer;
    private final ThermostatSimulation thermostatSimulation = new ThermostatSimulation();
    private final TemperatureControlImpl temperatureControl = new TemperatureControlImpl(this.thermostatSimulation);
    public static ServerInformation serverInfo = new ServerInformation("Thermostat Server", "Simple Example of a Thermostat", "www.sila-standard.org", "v0.0");

    public ThermostatServer(@NonNull ArgumentHelper argumentHelper) {
        if (argumentHelper == null) {
            throw new NullPointerException("argumentHelper is marked non-null but is null");
        }
        try {
            SiLAServer.Builder builder = argumentHelper.getConfigFile().isPresent() ? SiLAServer.Builder.withConfig((Path)((Path)argumentHelper.getConfigFile().get()), (ServerInformation)serverInfo) : SiLAServer.Builder.withoutConfig((ServerInformation)serverInfo);
            builder.withPersistedTLS(argumentHelper.getPrivateKeyFile(), argumentHelper.getCertificateFile(), argumentHelper.getCertificatePassword());
            argumentHelper.getPort().ifPresent(arg_0 -> ((SiLAServer.Builder)builder).withPort(arg_0));
            argumentHelper.getInterface().ifPresent(arg_0 -> ((SiLAServer.Builder)builder).withDiscovery(arg_0));
            if (argumentHelper.useUnsafeCommunication()) {
                builder.withUnsafeCommunication(true);
            }
            builder.addFeature(FileUtils.getFileContent((InputStream)EmptyClass.class.getResourceAsStream(featureLocation)), (BindableService)this.temperatureControl);
            this.siLAServer = builder.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.temperatureControl.temperatureManager.close();
        this.siLAServer.close();
    }

    public static void main(String[] args) {
        ArgumentHelper argumentHelper = new ArgumentHelper(args, SERVER_TYPE);
        try (ThermostatServer server = new ThermostatServer(argumentHelper);){
            Runtime.getRuntime().addShutdownHook(new Thread(server::close));
            Utils.blockUntilStop();
        }
        System.out.println("termination complete.");
    }

    static class TemperatureControlImpl
    extends TemperatureControllerGrpc.TemperatureControllerImplBase {
        private final ThermostatSimulation thermostatSimulation;
        ObservableCommandManager<TemperatureControllerOuterClass.ControlTemperature_Parameters, TemperatureControllerOuterClass.ControlTemperature_Responses> temperatureManager = new ObservableCommandManager(new ObservableCommandTaskRunner(1, 1), this::runCommandTask, Duration.ofSeconds(1000L));

        public TemperatureControlImpl(ThermostatSimulation thermostatSimulation) {
            this.thermostatSimulation = thermostatSimulation;
        }

        private TemperatureControllerOuterClass.ControlTemperature_Responses runCommandTask(@NonNull ObservableCommandWrapper<TemperatureControllerOuterClass.ControlTemperature_Parameters, TemperatureControllerOuterClass.ControlTemperature_Responses> command) throws StatusRuntimeException {
            double startTemperature;
            if (command == null) {
                throw new NullPointerException("command is marked non-null but is null");
            }
            double targetTemperature = ((TemperatureControllerOuterClass.ControlTemperature_Parameters)command.getParameter()).getTargetTemperature().getValue();
            if (targetTemperature == (startTemperature = this.thermostatSimulation.getCurrentTemperature())) {
                return TemperatureControllerOuterClass.ControlTemperature_Responses.newBuilder().build();
            }
            CompletableFuture future = new CompletableFuture();
            this.thermostatSimulation.setTargetTemperature(targetTemperature);
            ThermostatSimulation.TemperatureListener listener = temperature -> {
                double absoluteTemperatureDifference = Math.abs(targetTemperature - temperature);
                double progress = 1.0 - absoluteTemperatureDifference / Math.abs(targetTemperature - startTemperature);
                Duration timeLeft = Duration.ofSeconds((long)(absoluteTemperatureDifference / 1.0));
                command.setExecutionInfoAndNotify(progress, timeLeft);
                if (absoluteTemperatureDifference <= 1.0) {
                    future.complete(temperature);
                }
            };
            this.thermostatSimulation.addListener(listener);
            try {
                future.get();
                TemperatureControllerOuterClass.ControlTemperature_Responses controlTemperature_Responses = TemperatureControllerOuterClass.ControlTemperature_Responses.newBuilder().build();
                return controlTemperature_Responses;
            }
            catch (InterruptedException | ExecutionException e) {
                throw SiLAErrors.generateGenericExecutionError((Throwable)e);
            }
            finally {
                this.thermostatSimulation.removeListener(listener);
            }
        }

        @Override
        public void controlTemperature(@NonNull TemperatureControllerOuterClass.ControlTemperature_Parameters parameters, @NonNull StreamObserver<SiLAFramework.CommandConfirmation> commandConfirmationStreamObserver) {
            if (parameters == null) {
                throw new NullPointerException("parameters is marked non-null but is null");
            }
            if (commandConfirmationStreamObserver == null) {
                throw new NullPointerException("commandConfirmationStreamObserver is marked non-null but is null");
            }
            this.temperatureManager.addCommand((Object)parameters, commandConfirmationStreamObserver);
        }

        @Override
        public void controlTemperatureInfo(@NonNull SiLAFramework.CommandExecutionUUID commandExecutionUUID, @NonNull StreamObserver<SiLAFramework.ExecutionInfo> executionInfoStreamObserver) {
            if (commandExecutionUUID == null) {
                throw new NullPointerException("commandExecutionUUID is marked non-null but is null");
            }
            if (executionInfoStreamObserver == null) {
                throw new NullPointerException("executionInfoStreamObserver is marked non-null but is null");
            }
            this.temperatureManager.get(commandExecutionUUID).addStateObserver(executionInfoStreamObserver);
        }

        @Override
        public void controlTemperatureResult(@NonNull SiLAFramework.CommandExecutionUUID commandExecutionUUID, @NonNull StreamObserver<TemperatureControllerOuterClass.ControlTemperature_Responses> responsesStreamObserver) {
            if (commandExecutionUUID == null) {
                throw new NullPointerException("commandExecutionUUID is marked non-null but is null");
            }
            if (responsesStreamObserver == null) {
                throw new NullPointerException("responsesStreamObserver is marked non-null but is null");
            }
            this.temperatureManager.get(commandExecutionUUID).sendResult(responsesStreamObserver);
        }

        @Override
        public void subscribeCurrentTemperature(@NonNull TemperatureControllerOuterClass.Subscribe_CurrentTemperature_Parameters parameters, @NonNull StreamObserver<TemperatureControllerOuterClass.Subscribe_CurrentTemperature_Responses> responsesStreamObserver) {
            if (parameters == null) {
                throw new NullPointerException("parameters is marked non-null but is null");
            }
            if (responsesStreamObserver == null) {
                throw new NullPointerException("responsesStreamObserver is marked non-null but is null");
            }
            this.sendTemperature(responsesStreamObserver, this.thermostatSimulation.getCurrentTemperature());
            ThermostatSimulation.TemperatureListener temperatureListener = temperature -> this.sendTemperature(responsesStreamObserver, temperature);
            this.thermostatSimulation.addListener(temperatureListener);
            log.info("[subscribeCurrentTemperature] Subscription started");
            while (!Context.current().isCancelled()) {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.thermostatSimulation.removeListener(temperatureListener);
            log.info("[subscribeCurrentTemperature] Subscription cancelled");
            responsesStreamObserver.onCompleted();
        }

        private void sendTemperature(@NonNull StreamObserver<TemperatureControllerOuterClass.Subscribe_CurrentTemperature_Responses> responsesStreamObserver, double temperature) {
            if (responsesStreamObserver == null) {
                throw new NullPointerException("responsesStreamObserver is marked non-null but is null");
            }
            responsesStreamObserver.onNext((Object)TemperatureControllerOuterClass.Subscribe_CurrentTemperature_Responses.newBuilder().setCurrentTemperature(SiLAReal.from((double)temperature)).build());
        }
    }
}

