/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.thermostat;

import com.google.common.collect.ImmutableMap;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.CloudClientEndpointGrpc;
import sila2.org.silastandard.SiLAFramework;
import sila2.org.silastandard.examples.temperaturecontroller.v1.TemperatureControllerOuterClass;
import sila_java.examples.thermostat.ThermostatServer;
import sila_java.examples.thermostat.ThermostatSimulation;
import sila_java.library.cloudier.server.CloudierConnectionConfigurationService;
import sila_java.library.cloudier.server.CloudierServerEndpoint;
import sila_java.library.cloudier.server.CloudierSiLAService;
import sila_java.library.cloudier.server.MessageCaseHandler;
import sila_java.library.core.sila.clients.ChannelFactory;
import sila_java.library.core.utils.FileUtils;
import sila_java.library.core.utils.Utils;
import sila_java.library.sila_base.EmptyClass;

public class CloudThermostatServer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(CloudThermostatServer.class);
    private final CloudierSiLAService cloudierSiLAService;
    private final CloudierConnectionConfigurationService cloudierConnectionConfigurationService;
    private final ThermostatSimulation thermostatSimulation = new ThermostatSimulation();
    private final ThermostatServer.TemperatureControlImpl temperatureControl = new ThermostatServer.TemperatureControlImpl(this.thermostatSimulation);
    private CloudClientEndpointGrpc.CloudClientEndpointStub clientEndpoint;
    private CloudierServerEndpoint cloudServerEndpointService;
    private ManagedChannel channel;

    public static void main(String[] args) throws IOException {
        UUID serverUUID = UUID.randomUUID();
        new CloudThermostatServer(serverUUID);
        Utils.blockUntilStop();
    }

    public CloudThermostatServer(UUID serverUUID) throws IOException {
        ImmutableMap immutableMap = ImmutableMap.builder().put((Object)"SiLAService", (Object)FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/core/SiLAService.sila.xml")))).put((Object)"ConnectionConfigurationService", (Object)FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/core/ConnectionConfigurationService.sila.xml")))).put((Object)"TemperatureController", (Object)FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/examples/TemperatureController.sila.xml")))).build();
        this.cloudierSiLAService = new CloudierSiLAService("Cloud Thermostat Server", ThermostatServer.serverInfo.getType(), serverUUID.toString(), ThermostatServer.serverInfo.getVersion(), ThermostatServer.serverInfo.getDescription(), ThermostatServer.serverInfo.getVendorURL(), (Map)immutableMap);
        this.cloudierConnectionConfigurationService = new CloudierConnectionConfigurationService(false, connectionMode -> {});
        this.startServerInitiatedConnection();
    }

    private void startServerInitiatedConnection() {
        this.channel = ChannelFactory.getTLSEncryptedChannel((String)"localhost", (int)50051);
        this.clientEndpoint = CloudClientEndpointGrpc.newStub((Channel)this.channel);
        HashMap<String, MessageCaseHandler> callForwarderMap = new HashMap<String, MessageCaseHandler>(){
            {
                this.put("org.silastandard/examples/TemperatureController/v1/Command/ControlTemperature", new MessageCaseHandler().withObservableCommand(TemperatureControllerOuterClass.ControlTemperature_Parameters.parser(), CloudThermostatServer.this.temperatureControl::controlTemperature).withExecInfo(SiLAFramework.CommandExecutionUUID.parser(), CloudThermostatServer.this.temperatureControl::controlTemperatureInfo).withResult(SiLAFramework.CommandExecutionUUID.parser(), CloudThermostatServer.this.temperatureControl::controlTemperatureResult));
                this.put("org.silastandard/examples/TemperatureController/v1/Property/CurrentTemperature", new MessageCaseHandler().withObservableProperty(TemperatureControllerOuterClass.Subscribe_CurrentTemperature_Parameters.parser(), CloudThermostatServer.this.temperatureControl::subscribeCurrentTemperature));
            }
        };
        this.cloudServerEndpointService = new CloudierServerEndpoint(this.cloudierSiLAService, this.cloudierConnectionConfigurationService, this.clientEndpoint, (Map)callForwarderMap);
    }

    @Override
    public void close() {
        this.channel.shutdown();
        this.temperatureControl.temperatureManager.close();
    }
}

