/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.thermostat;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.examples.thermostat.ThermostatSimulation;

public class ThermostatSimulation {
    private static final Logger log = LoggerFactory.getLogger(ThermostatSimulation.class);
    public static final double KELVIN_PER_SECONDS = 1.0;
    public static final double UPDATE_INTERVAL = 1.0;
    public static final double KELVIN_ACCURACY = 1.0;
    public static final double KELVIN_RAMP = 1.0;
    private final AtomicDouble currentTemperature = new AtomicDouble(293.0);
    private final AtomicDouble targetTemperature = new AtomicDouble(293.0);
    private final List<TemperatureListener> temperatureListenerList = new CopyOnWriteArrayList();
    private final Thread agentThread = new Thread((Runnable)new TemperatureChangeAgent(this, null), ThermostatSimulation.class.getName() + "_" + TemperatureChangeAgent.class.getName());

    public ThermostatSimulation() {
        this.agentThread.setDaemon(true);
        this.agentThread.start();
    }

    public void addListener(@NonNull TemperatureListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.temperatureListenerList.add(listener);
    }

    public void removeListener(@NonNull TemperatureListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.temperatureListenerList.remove(listener);
    }

    public void setTargetTemperature(double targetTemperature) {
        this.targetTemperature.set(targetTemperature);
    }

    public double getCurrentTemperature() {
        return this.currentTemperature.get();
    }

    static /* synthetic */ AtomicDouble access$100(ThermostatSimulation x0) {
        return x0.currentTemperature;
    }

    static /* synthetic */ AtomicDouble access$200(ThermostatSimulation x0) {
        return x0.targetTemperature;
    }

    static /* synthetic */ List access$300(ThermostatSimulation x0) {
        return x0.temperatureListenerList;
    }

    static /* synthetic */ Logger access$400() {
        return log;
    }
}

