/*
 * Decompiled with CFR 0.152.
 */
package sila_java.examples.thermostat;

import io.grpc.Channel;
import io.grpc.Context;
import io.grpc.ManagedChannel;
import java.time.Duration;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLAFramework;
import sila2.org.silastandard.examples.temperaturecontroller.v1.TemperatureControllerGrpc;
import sila2.org.silastandard.examples.temperaturecontroller.v1.TemperatureControllerOuterClass;
import sila_java.library.core.sila.clients.ChannelFactory;
import sila_java.library.core.sila.types.SiLAReal;
import sila_java.library.manager.ServerFinder;
import sila_java.library.manager.ServerManager;
import sila_java.library.manager.models.Server;

public class ThermostatClient {
    private static final Logger log = LoggerFactory.getLogger(ThermostatClient.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        try (ServerManager serverManager = ServerManager.getInstance();){
            Server server = (Server)ServerFinder.filterBy((ServerFinder.Filter[])new ServerFinder.Filter[]{ServerFinder.Filter.type((String)"ThermostatServer")}).scanAndFindOne(Duration.ofMinutes(1L)).orElseThrow(() -> new RuntimeException("No Thermostat server found within time"));
            log.info("Found Server!");
            ManagedChannel serviceChannel = ChannelFactory.getTLSEncryptedChannel((String)server.getHost(), (int)server.getPort(), (String)server.getCertificateAuthority());
            try {
                TemperatureControllerGrpc.TemperatureControllerBlockingStub blockingStub = TemperatureControllerGrpc.newBlockingStub((Channel)serviceChannel);
                SiLAFramework.CommandConfirmation commandConfirmation = blockingStub.controlTemperature(TemperatureControllerOuterClass.ControlTemperature_Parameters.newBuilder().setTargetTemperature(SiLAReal.from((float)313.0f)).build());
                Context.CancellableContext cancellableContext = Context.current().withCancellation();
                cancellableContext.run(() -> {
                    Iterator<TemperatureControllerOuterClass.Subscribe_CurrentTemperature_Responses> temperatureIterator = blockingStub.subscribeCurrentTemperature(TemperatureControllerOuterClass.Subscribe_CurrentTemperature_Parameters.newBuilder().build());
                    Iterator<SiLAFramework.ExecutionInfo> ExecutionInfoIterator = blockingStub.controlTemperatureInfo(commandConfirmation.getCommandExecutionUUID());
                    SiLAFramework.ExecutionInfo ExecutionInfo2 = ExecutionInfoIterator.next();
                    System.out.println("Initial Execution State: " + ExecutionInfo2.toString());
                    while (ExecutionInfo2.getCommandStatus().equals((Object)SiLAFramework.ExecutionInfo.CommandStatus.running)) {
                        ExecutionInfo2 = ExecutionInfoIterator.next();
                        System.out.println("Got Command Status: " + ExecutionInfo2.toString());
                        System.out.println("Got temperature " + temperatureIterator.next());
                    }
                });
                cancellableContext.cancel(null);
                System.out.println("Stopping...");
            }
            finally {
                serviceChannel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
            }
        }
        System.out.println("Stopped");
    }
}

