/*
 * Decompiled with CFR 0.152.
 */
package sila_java.interoperability.client.features;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.test.observablepropertytest.v1.ObservablePropertyTestGrpc;
import sila2.org.silastandard.test.observablepropertytest.v1.ObservablePropertyTestOuterClass;
import sila_java.library.core.sila.types.SiLAInteger;

public class ObservablePropertyTest {
    private static final Logger log = LoggerFactory.getLogger(ObservablePropertyTest.class);
    private final ObservablePropertyTestGrpc.ObservablePropertyTestBlockingStub blockingStub;

    public ObservablePropertyTest(ManagedChannel channel) {
        this.blockingStub = ObservablePropertyTestGrpc.newBlockingStub((Channel)channel);
    }

    public void setValue(long value) {
        ObservablePropertyTestOuterClass.SetValue_Responses responses = this.blockingStub.setValue(ObservablePropertyTestOuterClass.SetValue_Parameters.newBuilder().setValue(SiLAInteger.from((long)value)).build());
    }

    public void subscribeAlternating() {
        Iterator iterator = this.blockingStub.subscribeAlternating(ObservablePropertyTestOuterClass.Subscribe_Alternating_Parameters.newBuilder().build());
        if (iterator.next() == iterator.next()) {
            throw new RuntimeException("Observable property not alternating");
        }
        log.info("Observable property is alternating");
    }

    public void subscribeEditable() {
        Iterator iterator = this.blockingStub.subscribeEditable(ObservablePropertyTestOuterClass.Subscribe_Editable_Parameters.newBuilder().build());
        long nextValue = ((ObservablePropertyTestOuterClass.Subscribe_Editable_Responses)iterator.next()).getEditable().getValue() - 1L;
        this.setValue(nextValue);
        if (((ObservablePropertyTestOuterClass.Subscribe_Editable_Responses)iterator.next()).getEditable().getValue() != nextValue) {
            throw new RuntimeException("Observable property is not editable");
        }
        log.info("Observable property is editable");
    }

    public void subscribeFixedValue() {
        Iterator iterator = this.blockingStub.subscribeFixedValue(ObservablePropertyTestOuterClass.Subscribe_FixedValue_Parameters.newBuilder().build());
        if (((ObservablePropertyTestOuterClass.Subscribe_FixedValue_Responses)iterator.next()).getFixedValue().getValue() != 42L) {
            throw new RuntimeException("Observable property is not fix");
        }
        log.info("Observable property is fix");
    }
}

