/*
 * Decompiled with CFR 0.152.
 */
package sila_java.interoperability.client;

import io.grpc.ManagedChannel;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.interoperability.client.features.BinaryTransferTest;
import sila_java.interoperability.client.features.ErrorHandlingTest;
import sila_java.interoperability.client.features.MetadataConsumerTest;
import sila_java.interoperability.client.features.MetadataProvider;
import sila_java.interoperability.client.features.ObservableCommandTest;
import sila_java.interoperability.client.features.ObservablePropertyTest;
import sila_java.interoperability.client.features.UnobservableCommandTest;
import sila_java.interoperability.client.features.UnobservablePropertyTest;
import sila_java.library.core.sila.clients.ChannelFactory;
import sila_java.library.manager.ServerFinder;
import sila_java.library.manager.ServerManager;
import sila_java.library.manager.models.Server;

public class Client {
    private static final Logger log = LoggerFactory.getLogger(Client.class);
    public static final String SERVER_TYPE = "InteroperabilitySiLAServer";
    private final ManagedChannel serviceChannel;
    private final UnobservablePropertyTest unobservablePropertyTest;
    private final UnobservableCommandTest unobservableCommandTest;
    private final ObservablePropertyTest observablePropertyTest;
    private final ObservableCommandTest observableCommandTest;
    private final MetadataProvider metadataProvider;
    private final MetadataConsumerTest metadataConsumerTest;
    private final ErrorHandlingTest errorHandlingTest;
    private final BinaryTransferTest binaryTransferTest;

    public Client(ManagedChannel serviceChannel) {
        this.serviceChannel = serviceChannel;
        this.unobservablePropertyTest = new UnobservablePropertyTest(serviceChannel);
        this.unobservableCommandTest = new UnobservableCommandTest(serviceChannel);
        this.observablePropertyTest = new ObservablePropertyTest(serviceChannel);
        this.observableCommandTest = new ObservableCommandTest(serviceChannel);
        this.metadataProvider = new MetadataProvider(serviceChannel);
        this.metadataConsumerTest = new MetadataConsumerTest(serviceChannel);
        this.errorHandlingTest = new ErrorHandlingTest(serviceChannel);
        this.binaryTransferTest = new BinaryTransferTest(serviceChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try (ServerManager serverManager = ServerManager.getInstance();){
            Server server = (Server)ServerFinder.filterBy((ServerFinder.Filter[])new ServerFinder.Filter[]{ServerFinder.Filter.type((String)SERVER_TYPE)}).scanAndFindOne(Duration.ofMinutes(1L)).orElseThrow(() -> new RuntimeException("No InteroperabilitySiLAServer found within time"));
            log.info("Found Server!");
            ManagedChannel serviceChannel = ChannelFactory.getTLSEncryptedChannel((String)server.getHost(), (int)server.getPort(), (String)server.getCertificateAuthority());
            try {
                Client client = new Client(serviceChannel);
                client.runUnobservablePropertyTest();
                client.runUnobservableCommandTest();
                client.runObservablePropertyTest();
                client.runObservableCommandTest();
                client.runMetadataProvider();
                client.runMetadataConsumerTest();
                client.runErrorHandlingTest();
                client.runBinaryTransferTest();
            }
            finally {
                serviceChannel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
            }
        }
    }

    public void runBinaryTransferTest() {
        this.binaryTransferTest.getFCPAffectedByMetadataString();
        this.binaryTransferTest.binaryValueDirectly();
        this.binaryTransferTest.echoBinariesObservably();
        this.binaryTransferTest.echoBinaryAndMetadataString();
        this.binaryTransferTest.binaryValueDirectly();
    }

    public void runErrorHandlingTest() {
        this.errorHandlingTest.raiseDefinedExecutionError();
        this.errorHandlingTest.raiseDefinedExecutionErrorObservably();
        this.errorHandlingTest.raiseUndefinedExecutionError();
        this.errorHandlingTest.raiseUndefinedExecutionErrorObservably();
        this.errorHandlingTest.raiseDefinedExecutionErrorOnGet();
        this.errorHandlingTest.raiseDefinedExecutionErrorOnSubscribe();
        this.errorHandlingTest.raiseUndefinedExecutionErrorOnGet();
        this.errorHandlingTest.raiseUndefinedExecutionErrorOnSubscribe();
        this.errorHandlingTest.raiseDefinedExecutionErrorAfterValueWasSent();
        this.errorHandlingTest.raiseUndefinedExecutionErrorAfterValueWasSent();
    }

    public void runMetadataConsumerTest() {
        this.metadataConsumerTest.echoStringMetadata();
        this.metadataConsumerTest.unpackMetadata();
    }

    public void runMetadataProvider() {
        this.metadataProvider.getFCPAffectedByMetadataStringMetadata();
        this.metadataProvider.getFCPAffectedByMetadataStringMetadata();
    }

    public void runObservableCommandTest() {
        this.observableCommandTest.count(0.5, 5);
        this.observableCommandTest.echo(0.5, 42L);
    }

    public void runObservablePropertyTest() {
        this.observablePropertyTest.subscribeFixedValue();
        this.observablePropertyTest.subscribeAlternating();
        this.observablePropertyTest.subscribeEditable();
    }

    public void runUnobservableCommandTest() {
        this.unobservableCommandTest.commandWithParametersAndResponses();
        this.unobservableCommandTest.convertIntegerToString(42);
        this.unobservableCommandTest.joinIntegerAndString(42, "1337");
        this.unobservableCommandTest.splitStringAfterFirstChar("Sila");
    }

    public void runUnobservablePropertyTest() {
        this.unobservablePropertyTest.answerToEverything();
        this.unobservablePropertyTest.secondsSince1970();
    }
}

