/*
 * Decompiled with CFR 0.152.
 */
package sila_java.interoperability.client.features;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.util.Collections;
import java.util.UUID;
import sila2.org.silastandard.core.authenticationservice.v1.AuthenticationServiceGrpc;
import sila2.org.silastandard.core.authenticationservice.v1.AuthenticationServiceOuterClass;
import sila_java.library.core.sila.types.SiLAString;

public class Authentication {
    private final UUID serverUUID;
    private AuthenticationServiceGrpc.AuthenticationServiceBlockingStub blockingStub;

    public Authentication(ManagedChannel channel, UUID serverUUID) {
        this.blockingStub = AuthenticationServiceGrpc.newBlockingStub((Channel)channel);
        this.serverUUID = serverUUID;
    }

    public String login(String user, String password) {
        AuthenticationServiceOuterClass.Login_Responses login = this.blockingStub.login(AuthenticationServiceOuterClass.Login_Parameters.newBuilder().setUserIdentification(SiLAString.from((String)user)).setPassword(SiLAString.from((String)password)).setRequestedServer(SiLAString.from((String)this.serverUUID.toString())).addAllRequestedFeatures(Collections.singleton(SiLAString.from((String)"org.silastandard/test/AuthenticationTest/v1"))).build());
        return login.getAccessToken().getValue();
    }

    public void logout(String token) {
        AuthenticationServiceOuterClass.Logout_Responses logout = this.blockingStub.logout(AuthenticationServiceOuterClass.Logout_Parameters.newBuilder().setAccessToken(SiLAString.from((String)token)).build());
    }
}

