/*
 * Decompiled with CFR 0.152.
 */
package sila_java.interoperability.client.features;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import sila2.org.silastandard.SiLABinaryTransfer;
import sila2.org.silastandard.SiLAFramework;
import sila2.org.silastandard.core.authorizationservice.v1.AuthorizationServiceOuterClass;
import sila2.org.silastandard.test.authenticationtest.v1.AuthenticationTestGrpc;
import sila2.org.silastandard.test.authenticationtest.v1.AuthenticationTestOuterClass;
import sila_java.library.core.sila.mapping.grpc.ProtoMapper;
import sila_java.library.core.sila.types.SiLABinary;
import sila_java.library.core.sila.types.SiLAString;
import sila_java.library.manager.ServerManager;
import sila_java.library.manager.executor.BinaryUploader;
import sila_java.library.manager.executor.ExecutableServerCall;
import sila_java.library.manager.models.SiLACall;

public class AuthenticationTest {
    private final UUID serverUUID;
    private AuthenticationTestGrpc.AuthenticationTestBlockingStub blockingStub;

    public AuthenticationTest(ManagedChannel channel, UUID serverUUID) {
        this.blockingStub = AuthenticationTestGrpc.newBlockingStub((Channel)channel);
        this.serverUUID = serverUUID;
    }

    public void requiresToken(String token) {
        String metadatum = "{\"org.silastandard/core/AuthorizationService/v1/Metadata/AccessToken\":" + ProtoMapper.serializeToJson((MessageOrBuilder)AuthorizationServiceOuterClass.Metadata_AccessToken.newBuilder().setAccessToken(SiLAString.from((String)token)).build()) + "}";
        SiLACall siLACall = new SiLACall.Builder(this.serverUUID, "org.silastandard/test/AuthenticationTest/v1", "RequiresToken", SiLACall.Type.UNOBSERVABLE_COMMAND).withMetadata(metadatum).build();
        String string = (String)ServerManager.getInstance().getServerCallManager().runAsync(ExecutableServerCall.newBuilder((SiLACall)siLACall).build()).get(20L, TimeUnit.SECONDS);
    }

    public void requiresTokenForBinaryUpload(String token, byte[] bytes) {
        String metadatum = "{\"org.silastandard/core/AuthorizationService/v1/Metadata/AccessToken\":" + ProtoMapper.serializeToJson((MessageOrBuilder)AuthorizationServiceOuterClass.Metadata_AccessToken.newBuilder().setAccessToken(SiLAString.from((String)token)).build()) + "}";
        SiLAFramework.Binary binary = SiLABinary.fromBytes((byte[])bytes);
        if (bytes.length >= 0x200000) {
            try (ByteArrayInputStream targetStream = new ByteArrayInputStream(bytes);){
                BinaryUploader binaryUploader = new BinaryUploader((InputStream)targetStream, (long)bytes.length, "org.silastandard/test/AuthenticationTest/v1/Command/RequiresTokenForBinaryUpload/Parameter/BinaryToUpload");
                SiLACall siLACall = new SiLACall.Builder(this.serverUUID, "org.silastandard/test/AuthenticationTest/v1", "RequiresTokenForBinaryUpload", SiLACall.Type.UPLOAD_BINARY).withMetadata(metadatum).build();
                String createBinaryResponse = (String)ServerManager.getInstance().getServerCallManager().runAsync(ExecutableServerCall.newBuilder((SiLACall)siLACall).withBinaryUploader(binaryUploader).build()).get(20L, TimeUnit.SECONDS);
                SiLABinaryTransfer.CreateBinaryResponse.Builder builder = SiLABinaryTransfer.CreateBinaryResponse.newBuilder();
                JsonFormat.parser().merge(createBinaryResponse, (Message.Builder)builder);
                binary = SiLABinary.fromBinaryTransferUUID((String)builder.getBinaryTransferUUID());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Thread.sleep(1000L);
        AuthenticationTestOuterClass.RequiresTokenForBinaryUpload_Parameters parameters = AuthenticationTestOuterClass.RequiresTokenForBinaryUpload_Parameters.newBuilder().setBinaryToUpload(binary).build();
        SiLACall siLACall = new SiLACall.Builder(this.serverUUID, "org.silastandard/test/AuthenticationTest/v1", "RequiresTokenForBinaryUpload", SiLACall.Type.UNOBSERVABLE_COMMAND).withParameters(ProtoMapper.serializeToJson((MessageOrBuilder)parameters)).withMetadata(metadatum).build();
        String string = (String)ServerManager.getInstance().getServerCallManager().runAsync(ExecutableServerCall.newBuilder((SiLACall)siLACall).build()).get(20L, TimeUnit.SECONDS);
    }
}

