/*
 * Decompiled with CFR 0.152.
 */
package sila_java.interoperability.client.features;

import com.google.common.collect.Lists;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLABinaryTransfer;
import sila2.org.silastandard.SiLAFramework;
import sila2.org.silastandard.test.binarytransfertest.v1.BinaryTransferTestGrpc;
import sila2.org.silastandard.test.binarytransfertest.v1.BinaryTransferTestOuterClass;
import sila_java.library.core.sila.mapping.grpc.ProtoMapper;
import sila_java.library.core.sila.types.SiLABinary;
import sila_java.library.core.sila.types.SiLAString;
import sila_java.library.manager.ServerManager;
import sila_java.library.manager.executor.BinaryDownloader;
import sila_java.library.manager.executor.BinaryUploader;
import sila_java.library.manager.executor.ExecutableServerCall;
import sila_java.library.manager.models.SiLACall;

public class BinaryTransferTest {
    private static final Logger log = LoggerFactory.getLogger(BinaryTransferTest.class);
    private final UUID serverUUID;
    private BinaryTransferTestGrpc.BinaryTransferTestBlockingStub blockingStub;

    public BinaryTransferTest(ManagedChannel channel, @NonNull UUID serverUUID) {
        if (serverUUID == null) {
            throw new NullPointerException("serverUUID is marked non-null but is null");
        }
        this.blockingStub = BinaryTransferTestGrpc.newBlockingStub((Channel)channel);
        this.serverUUID = serverUUID;
    }

    public void getFCPAffectedByMetadataString() {
        this.blockingStub.getFCPAffectedByMetadataString(BinaryTransferTestOuterClass.Get_FCPAffectedByMetadata_String_Parameters.newBuilder().build());
    }

    public void echoBinaryValue(byte[] bytes) {
        block32: {
            BinaryTransferTestOuterClass.EchoBinaryValue_Responses echoBinaryValueResponses;
            SiLABinaryTransfer.CreateBinaryResponse.Builder builder;
            SiLAFramework.Binary binary = SiLABinary.fromBytes((byte[])bytes);
            if (bytes.length >= 0x200000) {
                try (ByteArrayInputStream targetStream = new ByteArrayInputStream(bytes);){
                    BinaryUploader binaryUploader = new BinaryUploader((InputStream)targetStream, (long)bytes.length, "org.silastandard/test/BinaryTransferTest/v1/Command/EchoBinaryValue/Parameter/BinaryValue");
                    SiLACall siLACall = new SiLACall.Builder(this.serverUUID, "org.silastandard/test/BinaryTransferTest/v1", "EchoBinaryValue", SiLACall.Type.UPLOAD_BINARY).build();
                    String createBinaryResponse = (String)ServerManager.getInstance().getServerCallManager().runAsync(ExecutableServerCall.newBuilder((SiLACall)siLACall).withBinaryUploader(binaryUploader).build()).get(20L, TimeUnit.SECONDS);
                    builder = SiLABinaryTransfer.CreateBinaryResponse.newBuilder();
                    JsonFormat.parser().merge(createBinaryResponse, (Message.Builder)builder);
                    binary = SiLABinary.fromBinaryTransferUUID((String)builder.getBinaryTransferUUID());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!(echoBinaryValueResponses = this.blockingStub.echoBinaryValue(BinaryTransferTestOuterClass.EchoBinaryValue_Parameters.newBuilder().setBinaryValue(binary).build())).getReceivedValue().hasBinaryTransferUUID()) break block32;
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                BinaryDownloader binaryDownloader = new BinaryDownloader((OutputStream)os, UUID.fromString(echoBinaryValueResponses.getReceivedValue().getBinaryTransferUUID()));
                String binaryInfo = (String)ServerManager.getInstance().getServerCallManager().runAsync(ExecutableServerCall.newBuilder((SiLACall)SiLACall.fromBinaryDownload((UUID)this.serverUUID)).withBinaryDownloader(binaryDownloader).build()).get(20L, TimeUnit.SECONDS);
                binaryDownloader.isValidAndCompleteOrThrow();
                builder = SiLABinaryTransfer.GetBinaryInfoResponse.newBuilder();
                JsonFormat.parser().merge(binaryInfo, (Message.Builder)builder);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void echoBinariesObservably(byte[] abcBytes, byte[] largeBinaryBytes, byte[] smallBinaryBytes) {
        block47: {
            SiLAFramework.ExecutionInfo.CommandStatus commandStatus;
            SiLABinaryTransfer.GetBinaryInfoResponse.Builder builder;
            String binaryInfo;
            BinaryDownloader binaryDownloader2;
            Throwable throwable;
            ByteArrayOutputStream os;
            SiLAFramework.Binary largeBinary;
            SiLAFramework.Binary smallBinary = SiLABinary.fromBytes((byte[])smallBinaryBytes);
            SiLAFramework.Binary abcBinary = SiLABinary.fromBytes((byte[])abcBytes);
            try (ByteArrayInputStream targetStream = new ByteArrayInputStream(largeBinaryBytes);){
                BinaryUploader binaryUploader = new BinaryUploader((InputStream)targetStream, (long)largeBinaryBytes.length, "org.silastandard/test/BinaryTransferTest/v1/Command/EchoBinariesObservably/Parameter/Binaries");
                SiLACall siLACall = new SiLACall.Builder(this.serverUUID, "org.silastandard/test/BinaryTransferTest/v1", "EchoBinariesObservably", SiLACall.Type.UPLOAD_BINARY).build();
                String createBinaryResponse = (String)ServerManager.getInstance().getServerCallManager().runAsync(ExecutableServerCall.newBuilder((SiLACall)siLACall).withBinaryUploader(binaryUploader).build()).get(20L, TimeUnit.SECONDS);
                SiLABinaryTransfer.CreateBinaryResponse.Builder builder2 = SiLABinaryTransfer.CreateBinaryResponse.newBuilder();
                JsonFormat.parser().merge(createBinaryResponse, (Message.Builder)builder2);
                largeBinary = SiLABinary.fromBinaryTransferUUID((String)builder2.getBinaryTransferUUID());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            SiLAFramework.CommandConfirmation commandConfirmation = this.blockingStub.echoBinariesObservably(BinaryTransferTestOuterClass.EchoBinariesObservably_Parameters.newBuilder().addAllBinaries(Lists.newArrayList((Object[])new SiLAFramework.Binary[]{abcBinary, largeBinary, smallBinary})).build());
            Iterator<BinaryTransferTestOuterClass.EchoBinariesObservably_IntermediateResponses> intermediateIterator = this.blockingStub.echoBinariesObservablyIntermediate(commandConfirmation.getCommandExecutionUUID());
            Iterator<SiLAFramework.ExecutionInfo> infoIterator = this.blockingStub.echoBinariesObservablyInfo(commandConfirmation.getCommandExecutionUUID());
            while (intermediateIterator.hasNext()) {
                BinaryTransferTestOuterClass.EchoBinariesObservably_IntermediateResponses next = intermediateIterator.next();
                if (!next.getBinary().hasBinaryTransferUUID()) continue;
                try {
                    os = new ByteArrayOutputStream();
                    throwable = null;
                    try {
                        binaryDownloader2 = new BinaryDownloader((OutputStream)os, UUID.fromString(next.getBinary().getBinaryTransferUUID()));
                        binaryInfo = (String)ServerManager.getInstance().getServerCallManager().runAsync(ExecutableServerCall.newBuilder((SiLACall)SiLACall.fromBinaryDownload((UUID)this.serverUUID)).withBinaryDownloader(binaryDownloader2).build()).get(20L, TimeUnit.SECONDS);
                        binaryDownloader2.isValidAndCompleteOrThrow();
                        builder = SiLABinaryTransfer.GetBinaryInfoResponse.newBuilder();
                        JsonFormat.parser().merge(binaryInfo, (Message.Builder)builder);
                    }
                    catch (Throwable binaryDownloader2) {
                        throwable = binaryDownloader2;
                        throw binaryDownloader2;
                    }
                    finally {
                        if (os == null) continue;
                        if (throwable != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable binaryDownloader2) {
                                throwable.addSuppressed(binaryDownloader2);
                            }
                            continue;
                        }
                        os.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            while (infoIterator.hasNext() && (commandStatus = infoIterator.next().getCommandStatus()) != SiLAFramework.ExecutionInfo.CommandStatus.finishedSuccessfully && commandStatus != SiLAFramework.ExecutionInfo.CommandStatus.finishedWithError) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            BinaryTransferTestOuterClass.EchoBinariesObservably_Responses result = this.blockingStub.echoBinariesObservablyResult(commandConfirmation.getCommandExecutionUUID());
            if (!result.getJointBinary().hasBinaryTransferUUID()) break block47;
            try {
                os = new ByteArrayOutputStream();
                throwable = null;
                try {
                    binaryDownloader2 = new BinaryDownloader((OutputStream)os, UUID.fromString(result.getJointBinary().getBinaryTransferUUID()));
                    binaryInfo = (String)ServerManager.getInstance().getServerCallManager().runAsync(ExecutableServerCall.newBuilder((SiLACall)SiLACall.fromBinaryDownload((UUID)this.serverUUID)).withBinaryDownloader(binaryDownloader2).build()).get(20L, TimeUnit.SECONDS);
                    binaryDownloader2.isValidAndCompleteOrThrow();
                    builder = SiLABinaryTransfer.GetBinaryInfoResponse.newBuilder();
                    JsonFormat.parser().merge(binaryInfo, (Message.Builder)builder);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (os != null) {
                        if (throwable != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            os.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void binaryValueDirectly() {
        block16: {
            BinaryTransferTestOuterClass.Get_BinaryValueDirectly_Responses binaryValueDirectly = this.blockingStub.getBinaryValueDirectly(BinaryTransferTestOuterClass.Get_BinaryValueDirectly_Parameters.newBuilder().build());
            if (!binaryValueDirectly.getBinaryValueDirectly().hasBinaryTransferUUID()) break block16;
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                BinaryDownloader binaryDownloader = new BinaryDownloader((OutputStream)os, UUID.fromString(binaryValueDirectly.getBinaryValueDirectly().getBinaryTransferUUID()));
                String binaryInfo = (String)ServerManager.getInstance().getServerCallManager().runAsync(ExecutableServerCall.newBuilder((SiLACall)SiLACall.fromBinaryDownload((UUID)this.serverUUID)).withBinaryDownloader(binaryDownloader).build()).get(20L, TimeUnit.SECONDS);
                binaryDownloader.isValidAndCompleteOrThrow();
                SiLABinaryTransfer.GetBinaryInfoResponse.Builder builder = SiLABinaryTransfer.GetBinaryInfoResponse.newBuilder();
                JsonFormat.parser().merge(binaryInfo, (Message.Builder)builder);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void binaryValueDownload() {
        block16: {
            BinaryTransferTestOuterClass.Get_BinaryValueDownload_Responses binaryValueDownload = this.blockingStub.getBinaryValueDownload(BinaryTransferTestOuterClass.Get_BinaryValueDownload_Parameters.newBuilder().build());
            if (!binaryValueDownload.getBinaryValueDownload().hasBinaryTransferUUID()) break block16;
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                BinaryDownloader binaryDownloader = new BinaryDownloader((OutputStream)os, UUID.fromString(binaryValueDownload.getBinaryValueDownload().getBinaryTransferUUID()));
                String binaryInfo = (String)ServerManager.getInstance().getServerCallManager().runAsync(ExecutableServerCall.newBuilder((SiLACall)SiLACall.fromBinaryDownload((UUID)this.serverUUID)).withBinaryDownloader(binaryDownloader).build()).get(20L, TimeUnit.SECONDS);
                binaryDownloader.isValidAndCompleteOrThrow();
                SiLABinaryTransfer.GetBinaryInfoResponse.Builder builder = SiLABinaryTransfer.GetBinaryInfoResponse.newBuilder();
                JsonFormat.parser().merge(binaryInfo, (Message.Builder)builder);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void echoBinaryAndMetadataString(byte[] bytes) {
        block32: {
            String metadatum = "{\"org.silastandard/test/BinaryTransferTest/v1/Metadata/String\":" + ProtoMapper.serializeToJson((MessageOrBuilder)BinaryTransferTestOuterClass.Metadata_String.newBuilder().setString(SiLAString.from((String)"abc")).build()) + "}";
            SiLAFramework.Binary binary = SiLABinary.fromBytes((byte[])bytes);
            if (bytes.length >= 0x200000) {
                try (ByteArrayInputStream targetStream = new ByteArrayInputStream(bytes);){
                    BinaryUploader binaryUploader = new BinaryUploader((InputStream)targetStream, (long)bytes.length, "org.silastandard/test/BinaryTransferTest/v1/Command/EchoBinaryAndMetadataString/Parameter/Binary");
                    SiLACall siLACall = new SiLACall.Builder(this.serverUUID, "org.silastandard/test/BinaryTransferTest/v1", "EchoBinaryAndMetadataString", SiLACall.Type.UPLOAD_BINARY).withMetadata(metadatum).build();
                    String createBinaryResponse = (String)ServerManager.getInstance().getServerCallManager().runAsync(ExecutableServerCall.newBuilder((SiLACall)siLACall).withBinaryUploader(binaryUploader).build()).get(20L, TimeUnit.SECONDS);
                    SiLABinaryTransfer.CreateBinaryResponse.Builder builder = SiLABinaryTransfer.CreateBinaryResponse.newBuilder();
                    JsonFormat.parser().merge(createBinaryResponse, (Message.Builder)builder);
                    binary = SiLABinary.fromBinaryTransferUUID((String)builder.getBinaryTransferUUID());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            BinaryTransferTestOuterClass.EchoBinaryAndMetadataString_Parameters parameters = BinaryTransferTestOuterClass.EchoBinaryAndMetadataString_Parameters.newBuilder().setBinary(binary).build();
            SiLACall siLACall = new SiLACall.Builder(this.serverUUID, "org.silastandard/test/BinaryTransferTest/v1", "EchoBinaryAndMetadataString", SiLACall.Type.UNOBSERVABLE_COMMAND).withParameters(ProtoMapper.serializeToJson((MessageOrBuilder)parameters)).withMetadata(metadatum).build();
            String response = (String)ServerManager.getInstance().getServerCallManager().runAsync(ExecutableServerCall.newBuilder((SiLACall)siLACall).build()).get(20L, TimeUnit.SECONDS);
            BinaryTransferTestOuterClass.EchoBinaryAndMetadataString_Responses.Builder parsedResponse = BinaryTransferTestOuterClass.EchoBinaryAndMetadataString_Responses.newBuilder();
            JsonFormat.parser().merge(response, (Message.Builder)parsedResponse);
            if (!parsedResponse.getBinary().hasBinaryTransferUUID()) break block32;
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                BinaryDownloader binaryDownloader = new BinaryDownloader((OutputStream)os, UUID.fromString(parsedResponse.getBinary().getBinaryTransferUUID()));
                String binaryInfo = (String)ServerManager.getInstance().getServerCallManager().runAsync(ExecutableServerCall.newBuilder((SiLACall)SiLACall.fromBinaryDownload((UUID)this.serverUUID)).withBinaryDownloader(binaryDownloader).build()).get(20L, TimeUnit.SECONDS);
                binaryDownloader.isValidAndCompleteOrThrow();
                SiLABinaryTransfer.GetBinaryInfoResponse.Builder builder = SiLABinaryTransfer.GetBinaryInfoResponse.newBuilder();
                JsonFormat.parser().merge(binaryInfo, (Message.Builder)builder);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

