/*
 * Decompiled with CFR 0.152.
 */
package sila_java.interoperability.client.features;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.test.unobservablecommandtest.v1.UnobservableCommandTestGrpc;
import sila2.org.silastandard.test.unobservablecommandtest.v1.UnobservableCommandTestOuterClass;
import sila_java.library.core.sila.types.SiLAInteger;
import sila_java.library.core.sila.types.SiLAString;

public class UnobservableCommandTest {
    private static final Logger log = LoggerFactory.getLogger(UnobservableCommandTest.class);
    private final UnobservableCommandTestGrpc.UnobservableCommandTestBlockingStub blockingStub;

    public UnobservableCommandTest(ManagedChannel channel) {
        this.blockingStub = UnobservableCommandTestGrpc.newBlockingStub((Channel)channel);
    }

    public void commandWithParametersAndResponses() {
        try {
            UnobservableCommandTestOuterClass.CommandWithoutParametersAndResponses_Responses commandWithoutParametersAndResponses_Responses = this.blockingStub.commandWithoutParametersAndResponses(UnobservableCommandTestOuterClass.CommandWithoutParametersAndResponses_Parameters.newBuilder().build());
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.CANCELLED) {
                log.info("Command without responses");
                return;
            }
            throw e;
        }
    }

    public String convertIntegerToString(int integer) {
        UnobservableCommandTestOuterClass.ConvertIntegerToString_Responses responses = this.blockingStub.convertIntegerToString(UnobservableCommandTestOuterClass.ConvertIntegerToString_Parameters.newBuilder().setInteger(SiLAInteger.from((long)integer)).build());
        log.info("String representation of {} is: {}", (Object)integer, (Object)responses.getStringRepresentation().getValue());
        return responses.getStringRepresentation().getValue();
    }

    public String joinIntegerAndString(int integer, String str) {
        UnobservableCommandTestOuterClass.JoinIntegerAndString_Responses responses = this.blockingStub.joinIntegerAndString(UnobservableCommandTestOuterClass.JoinIntegerAndString_Parameters.newBuilder().setInteger(SiLAInteger.from((long)integer)).setString(SiLAString.from((String)str)).build());
        log.info("Joined integer {} and string {} is: {}", new Object[]{integer, str, responses.getJoinedParameters().getValue()});
        return responses.getJoinedParameters().getValue();
    }

    public String[] splitStringAfterFirstChar(String str) {
        UnobservableCommandTestOuterClass.SplitStringAfterFirstCharacter_Responses responses = this.blockingStub.splitStringAfterFirstCharacter(UnobservableCommandTestOuterClass.SplitStringAfterFirstCharacter_Parameters.newBuilder().setString(SiLAString.from((String)str)).build());
        log.info("String {} split after first char is: {} and reminder: {}", new Object[]{str, responses.getFirstCharacter().getValue(), responses.getRemainder()});
        return new String[]{responses.getFirstCharacter().getValue(), responses.getRemainder().getValue()};
    }
}

