/*
 * Decompiled with CFR 0.152.
 */
package sila_java.interoperability.client.features;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLAFramework;
import sila2.org.silastandard.test.observablecommandtest.v1.ObservableCommandTestGrpc;
import sila2.org.silastandard.test.observablecommandtest.v1.ObservableCommandTestOuterClass;
import sila_java.library.core.sila.types.SiLAInteger;
import sila_java.library.core.sila.types.SiLAReal;

public class ObservableCommandTest {
    private static final Logger log = LoggerFactory.getLogger(ObservableCommandTest.class);
    private final ObservableCommandTestGrpc.ObservableCommandTestBlockingStub blockingStub;

    public ObservableCommandTest(ManagedChannel channel) {
        this.blockingStub = ObservableCommandTestGrpc.newBlockingStub((Channel)channel);
    }

    public void count(double seconds, int nb) {
        SiLAFramework.CommandConfirmation count = this.blockingStub.count(ObservableCommandTestOuterClass.Count_Parameters.newBuilder().setDelay(SiLAReal.from((double)seconds)).setN(SiLAInteger.from((long)nb)).build());
        Iterator intermediateIterator = this.blockingStub.countIntermediate(count.getCommandExecutionUUID());
        Iterator infoIterator = this.blockingStub.countInfo(count.getCommandExecutionUUID());
        SiLAFramework.ExecutionInfo.CommandStatus commandStatus = ((SiLAFramework.ExecutionInfo)infoIterator.next()).getCommandStatus();
        if (commandStatus != SiLAFramework.ExecutionInfo.CommandStatus.waiting && commandStatus != SiLAFramework.ExecutionInfo.CommandStatus.running) {
            throw new RuntimeException("Invalid observable command status");
        }
        log.info("Command request has been received {}", (Object)count.getCommandExecutionUUID().getValue());
        long it = 0L;
        while (it < (long)(nb - 1)) {
            it = ((ObservableCommandTestOuterClass.Count_IntermediateResponses)intermediateIterator.next()).getCurrentIteration().getValue();
        }
        while (commandStatus != SiLAFramework.ExecutionInfo.CommandStatus.finishedSuccessfully && commandStatus != SiLAFramework.ExecutionInfo.CommandStatus.finishedWithError) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            commandStatus = ((SiLAFramework.ExecutionInfo)infoIterator.next()).getCommandStatus();
        }
        ObservableCommandTestOuterClass.Count_Responses result = this.blockingStub.countResult(count.getCommandExecutionUUID());
        if (result.getIterationResponse().getValue() != (long)(nb - 1)) {
            throw new RuntimeException("Invalid count result");
        }
        log.info("Received valid count result {}", (Object)result.getIterationResponse().getValue());
    }

    public void echo(double seconds, long value) {
        SiLAFramework.CommandConfirmation echo = this.blockingStub.echoValueAfterDelay(ObservableCommandTestOuterClass.EchoValueAfterDelay_Parameters.newBuilder().setValue(SiLAInteger.from((long)value)).setDelay(SiLAReal.from((double)seconds)).build());
        Iterator infoIterator = this.blockingStub.echoValueAfterDelayInfo(echo.getCommandExecutionUUID());
        SiLAFramework.ExecutionInfo.CommandStatus commandStatus = ((SiLAFramework.ExecutionInfo)infoIterator.next()).getCommandStatus();
        if (commandStatus == SiLAFramework.ExecutionInfo.CommandStatus.waiting || commandStatus == SiLAFramework.ExecutionInfo.CommandStatus.running) {
            log.info("Command request has been received {}", (Object)echo.getCommandExecutionUUID().getValue());
        } else {
            throw new RuntimeException("Invalid observable command status");
        }
        while (commandStatus != SiLAFramework.ExecutionInfo.CommandStatus.finishedSuccessfully && commandStatus != SiLAFramework.ExecutionInfo.CommandStatus.finishedWithError) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            commandStatus = ((SiLAFramework.ExecutionInfo)infoIterator.next()).getCommandStatus();
        }
        ObservableCommandTestOuterClass.EchoValueAfterDelay_Responses result = this.blockingStub.echoValueAfterDelayResult(echo.getCommandExecutionUUID());
        if (result.getReceivedValue().getValue() != value) {
            throw new RuntimeException("Invalid echo result");
        }
        log.info("Received valid echo result {}", (Object)result.getReceivedValue().getValue());
    }
}

